/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.gridmix;

import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.locks.Condition;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.ClusterStatus;
import org.apache.hadoop.mapred.gridmix.JobFactory;
import org.apache.hadoop.mapred.gridmix.JobSubmitter;
import org.apache.hadoop.mapred.gridmix.Statistics;
import org.apache.hadoop.mapred.gridmix.UserResolver;
import org.apache.hadoop.tools.rumen.JobStoryProducer;

public class StressJobFactory
extends JobFactory<Statistics.ClusterStats> {
    public static final Log LOG = LogFactory.getLog(StressJobFactory.class);
    private final LoadStatus loadStatus = new LoadStatus();
    private final Condition condUnderloaded = this.lock.newCondition();
    private static final float OVERLOAD_MAPTASK_MAPSLOT_RATIO = 2.0f;
    public static final String CONF_OVERLOAD_MAPTASK_MAPSLOT_RATIO = "gridmix.throttle.maps.task-to-slot-ratio";
    final float overloadMapTaskMapSlotRatio;
    private static final float OVERLOAD_REDUCETASK_REDUCESLOT_RATIO = 2.5f;
    public static final String CONF_OVERLOAD_REDUCETASK_REDUCESLOT_RATIO = "gridmix.throttle.reduces.task-to-slot-ratio";
    final float overloadReduceTaskReduceSlotRatio;
    private static final float MAX_MAPSLOT_SHARE_PER_JOB = 0.1f;
    public static final String CONF_MAX_MAPSLOT_SHARE_PER_JOB = "gridmix.throttle.maps.max-slot-share-per-job";
    final float maxMapSlotSharePerJob;
    private static final float MAX_REDUCESLOT_SHARE_PER_JOB = 0.1f;
    public static final String CONF_MAX_REDUCESLOT_SHARE_PER_JOB = "gridmix.throttle.reducess.max-slot-share-per-job";
    final float maxReduceSlotSharePerJob;
    private static final float MAX_JOB_TRACKER_RATIO = 1.0f;
    public static final String CONF_MAX_JOB_TRACKER_RATIO = "gridmix.throttle.jobs-to-tracker-ratio";
    final float maxJobTrackerRatio;

    public StressJobFactory(JobSubmitter submitter, JobStoryProducer jobProducer, Path scratch, Configuration conf, CountDownLatch startFlag, UserResolver resolver) throws IOException {
        super(submitter, jobProducer, scratch, conf, startFlag, resolver);
        this.overloadMapTaskMapSlotRatio = conf.getFloat(CONF_OVERLOAD_MAPTASK_MAPSLOT_RATIO, 2.0f);
        this.overloadReduceTaskReduceSlotRatio = conf.getFloat(CONF_OVERLOAD_REDUCETASK_REDUCESLOT_RATIO, 2.5f);
        this.maxMapSlotSharePerJob = conf.getFloat(CONF_MAX_MAPSLOT_SHARE_PER_JOB, 0.1f);
        this.maxReduceSlotSharePerJob = conf.getFloat(CONF_MAX_REDUCESLOT_SHARE_PER_JOB, 0.1f);
        this.maxJobTrackerRatio = conf.getFloat(CONF_MAX_JOB_TRACKER_RATIO, 1.0f);
    }

    @Override
    public Thread createReaderThread() {
        return new StressReaderThread("StressJobFactory");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(Statistics.ClusterStats item) {
        this.lock.lock();
        try {
            ClusterStatus clusterMetrics = item.getStatus();
            try {
                this.checkLoadAndGetSlotsToBackfill(item, clusterMetrics);
            }
            catch (IOException e) {
                LOG.error((Object)"Couldn't get the new Status", (Throwable)e);
            }
            if (!this.loadStatus.overloaded()) {
                this.condUnderloaded.signalAll();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    float calcEffectiveIncompleteMapTasks(int mapSlotCapacity, int numMaps, float mapProgress) {
        float maxEffIncompleteMapTasks = Math.max(1.0f, (float)mapSlotCapacity * this.maxMapSlotSharePerJob);
        float mapProgressAdjusted = Math.max(Math.min(mapProgress, 1.0f), 0.0f);
        return Math.min(maxEffIncompleteMapTasks, (float)numMaps * (1.0f - mapProgressAdjusted));
    }

    float calcEffectiveIncompleteReduceTasks(int reduceSlotCapacity, int numReduces, float reduceProgress) {
        float maxEffIncompleteReduceTasks = Math.max(1.0f, (float)reduceSlotCapacity * this.maxReduceSlotSharePerJob);
        float reduceProgressAdjusted = Math.max(Math.min(reduceProgress, 1.0f), 0.0f);
        return Math.min(maxEffIncompleteReduceTasks, (float)numReduces * (1.0f - reduceProgressAdjusted));
    }

    private void checkLoadAndGetSlotsToBackfill(Statistics.ClusterStats stats, ClusterStatus clusterStatus) throws IOException {
        this.loadStatus.mapSlotCapacity = clusterStatus.getMaxMapTasks();
        this.loadStatus.reduceSlotCapacity = clusterStatus.getMaxReduceTasks();
        this.loadStatus.numJobsBackfill = (int)(this.maxJobTrackerRatio * (float)clusterStatus.getTaskTrackers()) - stats.getNumRunningJob();
        if (this.loadStatus.numJobsBackfill <= 0) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(System.currentTimeMillis() + " Overloaded is " + Boolean.TRUE.toString() + " NumJobsBackfill is " + this.loadStatus.numJobsBackfill));
            }
            return;
        }
        float incompleteMapTasks = 0.0f;
        for (Statistics.JobStats job : Statistics.ClusterStats.getRunningJobStats()) {
            float mapProgress = job.getJob().mapProgress();
            int noOfMaps = job.getNoOfMaps();
            incompleteMapTasks += this.calcEffectiveIncompleteMapTasks(clusterStatus.getMaxMapTasks(), noOfMaps, mapProgress);
        }
        this.loadStatus.mapSlotsBackfill = (int)(this.overloadMapTaskMapSlotRatio * (float)clusterStatus.getMaxMapTasks() - incompleteMapTasks);
        if (this.loadStatus.mapSlotsBackfill <= 0) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(System.currentTimeMillis() + " Overloaded is " + Boolean.TRUE.toString() + " MapSlotsBackfill is " + this.loadStatus.mapSlotsBackfill));
            }
            return;
        }
        float incompleteReduceTasks = 0.0f;
        for (Statistics.JobStats job : Statistics.ClusterStats.getRunningJobStats()) {
            int noOfReduces = job.getJob().getNumReduceTasks();
            if (noOfReduces <= 0) continue;
            float reduceProgress = job.getJob().reduceProgress();
            incompleteReduceTasks += this.calcEffectiveIncompleteReduceTasks(clusterStatus.getMaxReduceTasks(), noOfReduces, reduceProgress);
        }
        this.loadStatus.reduceSlotsBackfill = (int)(this.overloadReduceTaskReduceSlotRatio * (float)clusterStatus.getMaxReduceTasks() - incompleteReduceTasks);
        if (this.loadStatus.reduceSlotsBackfill <= 0) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(System.currentTimeMillis() + " Overloaded is " + Boolean.TRUE.toString() + " ReduceSlotsBackfill is " + this.loadStatus.reduceSlotsBackfill));
            }
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(System.currentTimeMillis() + " Overloaded is " + Boolean.FALSE.toString() + "Current load Status is " + this.loadStatus));
        }
    }

    @Override
    public void start() {
        LOG.info((Object)" Starting Stress submission ");
        this.rThread.start();
    }

    static /* synthetic */ LoadStatus access$000(StressJobFactory x0) {
        return x0.loadStatus;
    }

    static /* synthetic */ Condition access$100(StressJobFactory x0) {
        return x0.condUnderloaded;
    }

    static class LoadStatus {
        int mapSlotsBackfill = 0;
        int mapSlotCapacity = -1;
        int reduceSlotsBackfill = 0;
        int reduceSlotCapacity = -1;
        int numJobsBackfill = 0;

        LoadStatus() {
        }

        public boolean overloaded() {
            return this.mapSlotsBackfill <= 0 || this.reduceSlotsBackfill <= 0 || this.numJobsBackfill <= 0;
        }

        public String toString() {
            return " Overloaded = " + this.overloaded() + ", MapSlotBackfill = " + this.mapSlotsBackfill + ", MapSlotCapacity = " + this.mapSlotCapacity + ", ReduceSlotBackfill = " + this.reduceSlotsBackfill + ", ReduceSlotCapacity = " + this.reduceSlotCapacity + ", NumJobsBackfill = " + this.numJobsBackfill;
        }
    }

    private class StressReaderThread
    extends Thread {
        public StressReaderThread(String name) {
            super(name);
        }

        /*
         * Exception decompiling
         */
        @Override
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }
}

