/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.gridmix;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.gridmix.UserResolver;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.LineReader;

public class RoundRobinUserResolver
implements UserResolver {
    public static final Log LOG = LogFactory.getLog(RoundRobinUserResolver.class);
    private int uidx = 0;
    private List<UserGroupInformation> users = Collections.emptyList();
    private final HashMap<String, UserGroupInformation> usercache = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<UserGroupInformation> parseUserList(URI userUri, Configuration conf) throws IOException {
        if (null == userUri) {
            return Collections.emptyList();
        }
        Path userloc = new Path(userUri.toString());
        Text rawUgi = new Text();
        FileSystem fs = userloc.getFileSystem(conf);
        ArrayList<UserGroupInformation> ugiList = new ArrayList<UserGroupInformation>();
        LineReader in = null;
        try {
            in = new LineReader((InputStream)fs.open(userloc));
            while (in.readLine(rawUgi) > 0) {
                int e = rawUgi.find(",");
                if (rawUgi.getLength() == 0 || e == 0) {
                    throw new IOException("Missing username: " + rawUgi);
                }
                if (e == -1) {
                    e = rawUgi.getLength();
                }
                String username = Text.decode((byte[])rawUgi.getBytes(), (int)0, (int)e);
                UserGroupInformation ugi = null;
                try {
                    ugi = UserGroupInformation.createProxyUser((String)username, (UserGroupInformation)UserGroupInformation.getLoginUser());
                }
                catch (IOException ioe) {
                    LOG.error((Object)"Error while creating a proxy user ", (Throwable)ioe);
                }
                if (ugi == null) continue;
                ugiList.add(ugi);
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
        return ugiList;
    }

    @Override
    public synchronized boolean setTargetUsers(URI userloc, Configuration conf) throws IOException {
        this.uidx = 0;
        this.users = this.parseUserList(userloc, conf);
        if (this.users.size() == 0) {
            throw new IOException(RoundRobinUserResolver.buildEmptyUsersErrorMsg(userloc));
        }
        this.usercache.clear();
        return true;
    }

    static String buildEmptyUsersErrorMsg(URI userloc) {
        return "Empty user list is not allowed for RoundRobinUserResolver. Provided user resource URI '" + userloc + "' resulted in an empty user list.";
    }

    @Override
    public synchronized UserGroupInformation getTargetUgi(UserGroupInformation ugi) {
        UserGroupInformation targetUGI = this.usercache.get(ugi.getUserName());
        if (targetUGI == null) {
            targetUGI = this.users.get(this.uidx++ % this.users.size());
            this.usercache.put(ugi.getUserName(), targetUGI);
        }
        return targetUGI;
    }

    @Override
    public boolean needsTargetUsersList() {
        return true;
    }
}

