/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools.distcp2.mapred;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.tools.distcp2.CopyListing;
import org.apache.hadoop.tools.distcp2.DistCpOptions;
import org.apache.hadoop.tools.distcp2.StubContext;
import org.apache.hadoop.tools.distcp2.mapred.UniformSizeInputFormat;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestUniformSizeInputFormat {
    private static final Log LOG = LogFactory.getLog(TestUniformSizeInputFormat.class);
    private static MiniDFSCluster cluster;
    private static final int N_FILES = 20;
    private static final int SIZEOF_EACH_FILE = 1024;
    private static final Random random;
    private static int totalFileSize;
    private static final Credentials CREDENTIALS;

    @BeforeClass
    public static void setup() throws Exception {
        cluster = new MiniDFSCluster(new Configuration(), 1, true, null);
        totalFileSize = 0;
        for (int i = 0; i < 20; ++i) {
            totalFileSize += TestUniformSizeInputFormat.createFile("/tmp/source/" + String.valueOf(i), 1024);
        }
    }

    private static DistCpOptions getOptions(int nMaps) throws Exception {
        Path sourcePath = new Path(cluster.getFileSystem().getUri().toString() + "/tmp/source");
        Path targetPath = new Path(cluster.getFileSystem().getUri().toString() + "/tmp/target");
        ArrayList<Path> sourceList = new ArrayList<Path>();
        sourceList.add(sourcePath);
        DistCpOptions distCpOptions = new DistCpOptions(sourceList, targetPath);
        distCpOptions.setMaxMaps(nMaps);
        return distCpOptions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int createFile(String path, int fileSize) throws Exception {
        int n;
        FileSystem fileSystem = null;
        FSDataOutputStream outputStream = null;
        try {
            fileSystem = cluster.getFileSystem();
            outputStream = fileSystem.create(new Path(path), true, 0);
            int size = (int)Math.ceil((float)fileSize + (1.0f - random.nextFloat()) * (float)fileSize);
            outputStream.write(new byte[size]);
            n = size;
        }
        catch (Throwable throwable) {
            IOUtils.cleanup(null, (Closeable[])new Closeable[]{fileSystem, outputStream});
            throw throwable;
        }
        IOUtils.cleanup(null, (Closeable[])new Closeable[]{fileSystem, outputStream});
        return n;
    }

    @AfterClass
    public static void tearDown() {
        cluster.shutdown();
    }

    public void testGetSplits(int nMaps) throws Exception {
        DistCpOptions options = TestUniformSizeInputFormat.getOptions(nMaps);
        Configuration configuration = new Configuration();
        configuration.set("mapred.map.tasks", String.valueOf(options.getMaxMaps()));
        Path listFile = new Path(cluster.getFileSystem().getUri().toString() + "/tmp/testGetSplits_1/fileList.seq");
        CopyListing.getCopyListing((Configuration)configuration, (Credentials)CREDENTIALS, (DistCpOptions)options).buildListing(listFile, options);
        JobContext jobContext = new JobContext(configuration, new JobID());
        UniformSizeInputFormat uniformSizeInputFormat = new UniformSizeInputFormat();
        List splits = uniformSizeInputFormat.getSplits(jobContext);
        List<InputSplit> legacySplits = this.legacyGetSplits(listFile, nMaps);
        int sizePerMap = totalFileSize / nMaps;
        this.checkSplits(listFile, splits);
        this.checkAgainstLegacy(splits, legacySplits);
        int doubleCheckedTotalSize = 0;
        int previousSplitSize = -1;
        for (int i = 0; i < splits.size(); ++i) {
            InputSplit split = (InputSplit)splits.get(i);
            int currentSplitSize = 0;
            RecordReader recordReader = uniformSizeInputFormat.createRecordReader(split, null);
            StubContext stubContext = new StubContext(jobContext.getConfiguration(), (RecordReader<Text, FileStatus>)recordReader, 0);
            Mapper.Context taskAttemptContext = stubContext.getContext();
            recordReader.initialize(split, (TaskAttemptContext)taskAttemptContext);
            while (recordReader.nextKeyValue()) {
                Path sourcePath = ((FileStatus)recordReader.getCurrentValue()).getPath();
                FileSystem fs = sourcePath.getFileSystem(configuration);
                FileStatus[] fileStatus = fs.listStatus(sourcePath);
                Assert.assertEquals((long)fileStatus.length, (long)1L);
                currentSplitSize = (int)((long)currentSplitSize + fileStatus[0].getLen());
            }
            Assert.assertTrue((previousSplitSize == -1 || (double)Math.abs(currentSplitSize - previousSplitSize) < 0.1 * (double)sizePerMap || i == splits.size() - 1 ? 1 : 0) != 0);
            doubleCheckedTotalSize += currentSplitSize;
        }
        Assert.assertEquals((long)totalFileSize, (long)doubleCheckedTotalSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<InputSplit> legacyGetSplits(Path listFile, int numSplits) throws IOException {
        FileSystem fs = cluster.getFileSystem();
        FileStatus srcst = fs.getFileStatus(listFile);
        Configuration conf = fs.getConf();
        ArrayList<InputSplit> splits = new ArrayList<InputSplit>(numSplits);
        FileStatus value = new FileStatus();
        Text key = new Text();
        long targetsize = totalFileSize / numSplits;
        long pos = 0L;
        long last = 0L;
        long acc = 0L;
        long cbrem = srcst.getLen();
        SequenceFile.Reader sl = null;
        LOG.info((Object)("Average bytes per map: " + targetsize + ", Number of maps: " + numSplits + ", total size: " + totalFileSize));
        try {
            sl = new SequenceFile.Reader(fs, listFile, conf);
            while (sl.next((Writable)key, (Writable)value)) {
                if (acc + value.getLen() > targetsize && acc != 0L) {
                    long splitsize = last - pos;
                    FileSplit fileSplit = new FileSplit(listFile, pos, splitsize, null);
                    LOG.info((Object)("Creating split : " + fileSplit + ", bytes in split: " + splitsize));
                    splits.add((InputSplit)fileSplit);
                    cbrem -= splitsize;
                    pos = last;
                    acc = 0L;
                }
                acc += value.getLen();
                last = sl.getPosition();
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeStream(sl);
            throw throwable;
        }
        IOUtils.closeStream((Closeable)sl);
        if (cbrem != 0L) {
            FileSplit fileSplit = new FileSplit(listFile, pos, cbrem, null);
            LOG.info((Object)("Creating split : " + fileSplit + ", bytes in split: " + cbrem));
            splits.add((InputSplit)fileSplit);
        }
        return splits;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkSplits(Path listFile, List<InputSplit> splits) throws IOException {
        long lastEnd = 0L;
        for (InputSplit split : splits) {
            FileSplit fileSplit = (FileSplit)split;
            long start = fileSplit.getStart();
            Assert.assertEquals((long)lastEnd, (long)start);
            lastEnd = start + fileSplit.getLength();
        }
        FileSystem fs = cluster.getFileSystem();
        SequenceFile.Reader reader = new SequenceFile.Reader(fs, listFile, fs.getConf());
        try {
            reader.seek(lastEnd);
            FileStatus srcFileStatus = new FileStatus();
            Text srcRelPath = new Text();
            Assert.assertFalse((boolean)reader.next((Writable)srcRelPath, (Writable)srcFileStatus));
        }
        finally {
            IOUtils.closeStream((Closeable)reader);
        }
    }

    private void checkAgainstLegacy(List<InputSplit> splits, List<InputSplit> legacySplits) throws IOException, InterruptedException {
        Assert.assertEquals((long)legacySplits.size(), (long)splits.size());
        for (int index = 0; index < splits.size(); ++index) {
            FileSplit fileSplit = (FileSplit)splits.get(index);
            FileSplit legacyFileSplit = (FileSplit)legacySplits.get(index);
            Assert.assertEquals((long)fileSplit.getStart(), (long)legacyFileSplit.getStart());
        }
    }

    @Test
    public void testGetSplits() throws Exception {
        this.testGetSplits(9);
        for (int i = 1; i < 20; ++i) {
            this.testGetSplits(i);
        }
    }

    static {
        random = new Random();
        totalFileSize = 0;
        CREDENTIALS = new Credentials();
    }
}

