/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Random;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.logging.impl.Log4JLogger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FsShell;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.permission.PermissionStatus;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.mapred.MiniMRCluster;
import org.apache.hadoop.mapred.TaskTracker;
import org.apache.hadoop.tools.DistCh;
import org.apache.log4j.Level;

public class TestDistCh
extends TestCase {
    static final Long RANDOM_NUMBER_GENERATOR_SEED = null;
    private static final Random RANDOM = new Random();
    static final String TEST_ROOT_DIR;
    static final int NUN_SUBS = 5;
    static final FsPermission UMASK;

    public TestDistCh() {
        ((Log4JLogger)LogFactory.getLog((String)"org.apache.hadoop.hdfs.StateChange")).getLogger().setLevel(Level.OFF);
        ((Log4JLogger)DataNode.LOG).getLogger().setLevel(Level.OFF);
        ((Log4JLogger)FSNamesystem.LOG).getLogger().setLevel(Level.OFF);
        ((Log4JLogger)TaskTracker.LOG).getLogger().setLevel(Level.OFF);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDistCh() throws Exception {
        Configuration conf = new Configuration();
        MiniDFSCluster cluster = new MiniDFSCluster(conf, 2, true, null);
        FileSystem fs = cluster.getFileSystem();
        MiniMRCluster mr = new MiniMRCluster(2, fs.getUri().toString(), 1);
        FsShell shell = new FsShell(conf);
        try {
            int i;
            FileTree tree = new FileTree(fs, "testDistCh");
            FileStatus rootstatus = fs.getFileStatus(tree.rootdir);
            TestDistCh.runLsr(shell, tree.root, 0);
            String[] args = new String[RANDOM.nextInt(4) + 1];
            PermissionStatus[] newstatus = new PermissionStatus[5];
            LinkedList<Integer> indices = new LinkedList<Integer>();
            for (i = 0; i < 5; ++i) {
                indices.add(i);
            }
            for (i = 0; i < args.length; ++i) {
                int index = (Integer)indices.remove(RANDOM.nextInt(indices.size()));
                String sub = "sub" + index;
                boolean changeOwner = RANDOM.nextBoolean();
                boolean changeGroup = RANDOM.nextBoolean();
                boolean changeMode = !changeOwner && !changeGroup ? true : RANDOM.nextBoolean();
                String owner = changeOwner ? sub : "";
                String group = changeGroup ? sub : "";
                String permission = changeMode ? RANDOM.nextInt(8) + "" + RANDOM.nextInt(8) + "" + RANDOM.nextInt(8) : "";
                args[i] = tree.root + "/" + sub + ":" + owner + ":" + group + ":" + permission;
                newstatus[index] = new ChPermissionStatus(rootstatus, owner, group, permission);
            }
            for (i = 0; i < 5; ++i) {
                if (newstatus[i] != null) continue;
                newstatus[i] = new ChPermissionStatus(rootstatus);
            }
            System.out.println("args=" + Arrays.asList(args).toString().replace(",", ",\n  "));
            System.out.println("newstatus=" + Arrays.asList(newstatus).toString().replace(",", ",\n  "));
            new DistCh((Configuration)mr.createJobConf()).run(args);
            TestDistCh.runLsr(shell, tree.root, 0);
            for (i = 0; i < 5; ++i) {
                Path sub = new Path(tree.root + "/sub" + i);
                TestDistCh.checkFileStatus(newstatus[i], fs.getFileStatus(sub));
                for (FileStatus status : fs.listStatus(sub)) {
                    TestDistCh.checkFileStatus(newstatus[i], status);
                }
            }
        }
        finally {
            cluster.shutdown();
        }
    }

    static void checkFileStatus(PermissionStatus expected, FileStatus actual) {
        TestDistCh.assertEquals((String)expected.getUserName(), (String)actual.getOwner());
        TestDistCh.assertEquals((String)expected.getGroupName(), (String)actual.getGroup());
        FsPermission perm = expected.getPermission();
        if (!actual.isDir()) {
            perm = perm.applyUMask(UMASK);
        }
        TestDistCh.assertEquals((Object)perm, (Object)actual.getPermission());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String runLsr(FsShell shell, String root, int returnvalue) throws Exception {
        String results;
        System.out.println("root=" + root + ", returnvalue=" + returnvalue);
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        PrintStream out = new PrintStream(bytes);
        PrintStream oldOut = System.out;
        PrintStream oldErr = System.err;
        System.setOut(out);
        System.setErr(out);
        try {
            TestDistCh.assertEquals((int)returnvalue, (int)shell.run(new String[]{"-lsr", root}));
            results = bytes.toString();
        }
        finally {
            IOUtils.closeStream((Closeable)out);
            System.setOut(oldOut);
            System.setErr(oldErr);
        }
        System.out.println("results:\n" + results);
        return results;
    }

    static {
        long seed = RANDOM_NUMBER_GENERATOR_SEED == null ? RANDOM.nextLong() : RANDOM_NUMBER_GENERATOR_SEED.longValue();
        System.out.println("seed=" + seed);
        RANDOM.setSeed(seed);
        TEST_ROOT_DIR = new Path(System.getProperty("test.build.data", "/tmp")).toString().replace(' ', '+');
        UMASK = FsPermission.createImmutable((short)73);
    }

    static class ChPermissionStatus
    extends PermissionStatus {
        ChPermissionStatus(FileStatus filestatus) {
            this(filestatus, "", "", "");
        }

        ChPermissionStatus(FileStatus filestatus, String owner, String group, String permission) {
            super("".equals(owner) ? filestatus.getOwner() : owner, "".equals(group) ? filestatus.getGroup() : group, "".equals(permission) ? filestatus.getPermission() : new FsPermission(Short.parseShort(permission, 8)));
        }
    }

    static class FileTree {
        private final FileSystem fs;
        private final String root;
        private final Path rootdir;
        private int fcount = 0;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Path createSmallFile(Path dir) throws IOException {
            Path f = new Path(dir, "f" + ++this.fcount);
            Assert.assertTrue((!this.fs.exists(f) ? 1 : 0) != 0);
            FSDataOutputStream out = this.fs.create(f);
            try {
                out.writeBytes("createSmallFile: f=" + f);
            }
            finally {
                out.close();
            }
            Assert.assertTrue((boolean)this.fs.exists(f));
            return f;
        }

        Path mkdir(Path dir) throws IOException {
            Assert.assertTrue((boolean)this.fs.mkdirs(dir));
            Assert.assertTrue((boolean)this.fs.getFileStatus(dir).isDir());
            return dir;
        }

        FileTree(FileSystem fs, String name) throws IOException {
            int i;
            this.fs = fs;
            this.root = "/test/" + name;
            this.rootdir = this.mkdir(new Path(this.root));
            for (i = 0; i < 3; ++i) {
                this.createSmallFile(this.rootdir);
            }
            for (i = 0; i < 5; ++i) {
                Path sub = this.mkdir(new Path(this.root, "sub" + i));
                int num_files = RANDOM.nextInt(3);
                for (int j = 0; j < num_files; ++j) {
                    this.createSmallFile(sub);
                }
            }
            System.out.println("rootdir = " + this.rootdir);
        }
    }
}

