/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.authentication.client;

import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Properties;
import java.util.concurrent.Callable;
import org.apache.hadoop.security.authentication.KerberosTestUtils;
import org.apache.hadoop.security.authentication.client.Authenticator;
import org.apache.hadoop.security.authentication.client.AuthenticatorTestCase;
import org.apache.hadoop.security.authentication.client.KerberosAuthenticator;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

@Ignore(value="requires kerberos setup")
public class TestKerberosAuthenticator
extends AuthenticatorTestCase {
    private Properties getAuthenticationHandlerConfiguration() {
        Properties props = new Properties();
        props.setProperty("type", "kerberos");
        props.setProperty("kerberos.principal", KerberosTestUtils.getServerPrincipal());
        props.setProperty("kerberos.keytab", KerberosTestUtils.getKeytabFile());
        props.setProperty("kerberos.name.rules", "RULE:[1:$1@$0](.*@" + KerberosTestUtils.getRealm() + ")s/@.*//\n");
        return props;
    }

    @Test
    public void testFallbacktoPseudoAuthenticator() throws Exception {
        Properties props = new Properties();
        props.setProperty("type", "simple");
        props.setProperty("simple.anonymous.allowed", "false");
        TestKerberosAuthenticator.setAuthenticationHandlerConfig(props);
        this._testAuthentication((Authenticator)new KerberosAuthenticator(), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNotAuthenticated() throws Exception {
        TestKerberosAuthenticator.setAuthenticationHandlerConfig(this.getAuthenticationHandlerConfiguration());
        this.start();
        try {
            URL url = new URL(this.getBaseURL());
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.connect();
            Assert.assertEquals((long)401L, (long)conn.getResponseCode());
            Assert.assertTrue((conn.getHeaderField("WWW-Authenticate") != null ? 1 : 0) != 0);
        }
        finally {
            this.stop();
        }
    }

    @Test
    public void testAuthentication() throws Exception {
        TestKerberosAuthenticator.setAuthenticationHandlerConfig(this.getAuthenticationHandlerConfiguration());
        KerberosTestUtils.doAsClient(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                TestKerberosAuthenticator.this._testAuthentication((Authenticator)new KerberosAuthenticator(), false);
                return null;
            }
        });
    }

    @Test
    public void testAuthenticationPost() throws Exception {
        TestKerberosAuthenticator.setAuthenticationHandlerConfig(this.getAuthenticationHandlerConfiguration());
        KerberosTestUtils.doAsClient(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                TestKerberosAuthenticator.this._testAuthentication((Authenticator)new KerberosAuthenticator(), true);
                return null;
            }
        });
    }
}

