/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics2.lib;

import org.apache.hadoop.metrics2.MetricsException;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.lib.MetricMutable;
import org.apache.hadoop.metrics2.lib.MetricMutableCounterInt;
import org.apache.hadoop.metrics2.lib.MetricMutableCounterLong;
import org.apache.hadoop.metrics2.lib.MetricMutableFactory;
import org.apache.hadoop.metrics2.lib.MetricMutableGaugeInt;
import org.apache.hadoop.metrics2.lib.MetricMutableGaugeLong;
import org.apache.hadoop.metrics2.lib.MetricMutableStat;
import org.apache.hadoop.metrics2.lib.MetricsRegistry;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestMetricsRegistry {
    @Test
    public void testNewMetrics() {
        MetricMutableFactory factory = (MetricMutableFactory)Mockito.spy((Object)new MetricMutableFactory());
        final MetricsRegistry r = new MetricsRegistry("test", factory);
        r.newCounter("c1", "c1 desc", 1);
        r.newCounter("c2", "c2 desc", 2L);
        r.newGauge("g1", "g1 desc", 3);
        r.newGauge("g2", "g2 desc", 4L);
        r.newStat("s1", "s1 desc", "ops", "time");
        Assert.assertEquals((String)"num metrics in registry", (long)5L, (long)r.metrics().size());
        ((MetricMutableFactory)Mockito.verify((Object)factory)).newCounter("c1", "c1 desc", 1);
        ((MetricMutableFactory)Mockito.verify((Object)factory)).newCounter("c2", "c2 desc", 2L);
        ((MetricMutableFactory)Mockito.verify((Object)factory)).newGauge("g1", "g1 desc", 3);
        ((MetricMutableFactory)Mockito.verify((Object)factory)).newGauge("g2", "g2 desc", 4L);
        ((MetricMutableFactory)Mockito.verify((Object)factory)).newStat("s1", "s1 desc", "ops", "time", false);
        Assert.assertTrue((String)"c1 found", (boolean)(r.get("c1") instanceof MetricMutableCounterInt));
        Assert.assertTrue((String)"c2 found", (boolean)(r.get("c2") instanceof MetricMutableCounterLong));
        Assert.assertTrue((String)"g1 found", (boolean)(r.get("g1") instanceof MetricMutableGaugeInt));
        Assert.assertTrue((String)"g2 found", (boolean)(r.get("g2") instanceof MetricMutableGaugeLong));
        Assert.assertTrue((String)"s1 found", (boolean)(r.get("s1") instanceof MetricMutableStat));
        this.expectMetricsException("Metric name c1 already exists", new Runnable(){

            @Override
            public void run() {
                r.newCounter("c1", "test dup", 0);
            }
        });
    }

    @Test
    public void testIncrByName() {
        MetricsRecordBuilder builder = (MetricsRecordBuilder)Mockito.mock(MetricsRecordBuilder.class);
        MetricMutableFactory factory = new MetricMutableFactory(){

            public MetricMutable newMetric(String name) {
                return new MetricMutableGaugeInt(name, "test incr", 1);
            }
        };
        final MetricsRegistry r = new MetricsRegistry("test", factory);
        r.incr("g1");
        r.get("g1").snapshot(builder);
        ((MetricsRecordBuilder)Mockito.verify((Object)builder)).addGauge("g1", "test incr", 2);
        r.incr("c1", new MetricMutableFactory(){

            public MetricMutable newMetric(String name) {
                return new MetricMutableCounterInt(name, "test incr", 2);
            }
        });
        r.get("c1").snapshot(builder);
        ((MetricsRecordBuilder)Mockito.verify((Object)builder)).addCounter("c1", "test incr", 3);
        r.newStat("s1", "test incr", "ops", "time");
        this.expectMetricsException("Unsupported incr", new Runnable(){

            @Override
            public void run() {
                r.incr("s1");
            }
        });
        this.expectMetricsException("Metric n1 doesn't exist", new Runnable(){

            @Override
            public void run() {
                r.incr("n1", null);
            }
        });
    }

    @Test
    public void testDecrByName() {
        MetricsRecordBuilder builder = (MetricsRecordBuilder)Mockito.mock(MetricsRecordBuilder.class);
        MetricMutableFactory factory = new MetricMutableFactory(){

            public MetricMutable newMetric(String name) {
                return new MetricMutableGaugeInt(name, "test decr", 1);
            }
        };
        final MetricsRegistry r = new MetricsRegistry("test", factory);
        r.decr("g1");
        r.get("g1").snapshot(builder);
        ((MetricsRecordBuilder)Mockito.verify((Object)builder)).addGauge("g1", "test decr", 0);
        this.expectMetricsException("Unsupported decr", new Runnable(){

            @Override
            public void run() {
                r.decr("c1", new MetricMutableFactory(){

                    public MetricMutable newMetric(String name) {
                        return new MetricMutableCounterInt(name, "test decr", 2);
                    }
                });
            }
        });
        r.newStat("s1", "test decr", "ops", "time");
        this.expectMetricsException("Unsupported decr", new Runnable(){

            @Override
            public void run() {
                r.decr("s1");
            }
        });
        this.expectMetricsException("Metric n1 doesn't exist", new Runnable(){

            @Override
            public void run() {
                r.decr("n1", null);
            }
        });
    }

    @Test
    public void testAddByName() {
        MetricsRecordBuilder builder = (MetricsRecordBuilder)Mockito.mock(MetricsRecordBuilder.class);
        MetricMutableFactory factory = new MetricMutableFactory(){

            public MetricMutableStat newStat(String name) {
                return new MetricMutableStat(name, "test add", "ops", "time");
            }
        };
        final MetricsRegistry r = new MetricsRegistry("test", factory);
        r.add("s1", 42L);
        r.get("s1").snapshot(builder);
        ((MetricsRecordBuilder)Mockito.verify((Object)builder)).addCounter("s1_num_ops", "Number of ops for test add", 1L);
        ((MetricsRecordBuilder)Mockito.verify((Object)builder)).addGauge("s1_avg_time", "Average time for test add", 42.0);
        r.newCounter("c1", "test add", 1);
        r.newGauge("g1", "test add", 1);
        this.expectMetricsException("Unsupported add", new Runnable(){

            @Override
            public void run() {
                r.add("c1", 42L);
            }
        });
        this.expectMetricsException("Unsupported add", new Runnable(){

            @Override
            public void run() {
                r.add("g1", 42L);
            }
        });
        this.expectMetricsException("Metric n1 doesn't exist", new Runnable(){

            @Override
            public void run() {
                r.add("n1", 42L, null);
            }
        });
    }

    private void expectMetricsException(String prefix, Runnable fun) {
        try {
            fun.run();
        }
        catch (MetricsException e) {
            Assert.assertTrue((String)"expected exception", (boolean)e.getMessage().startsWith(prefix));
            return;
        }
        Assert.fail((String)("should've thrown '" + prefix + "...'"));
    }
}

