/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.pipes;

import java.security.PrivilegedExceptionAction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.ClusterWithLinuxTaskController;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.pipes.TestPipes;

public class TestPipesAsDifferentUser
extends ClusterWithLinuxTaskController {
    private static final Log LOG = LogFactory.getLog(TestPipesAsDifferentUser.class);

    public void testPipes() throws Exception {
        if (System.getProperty("compile.c++") == null) {
            LOG.info((Object)"compile.c++ is not defined, so skipping TestPipes");
            return;
        }
        if (!TestPipesAsDifferentUser.shouldRun()) {
            return;
        }
        super.startCluster();
        this.jobOwner.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws Exception {
                JobConf clusterConf = TestPipesAsDifferentUser.this.getClusterConf();
                Path inputPath = new Path(TestPipesAsDifferentUser.this.homeDirectory, "in");
                Path outputPath = new Path(TestPipesAsDifferentUser.this.homeDirectory, "out");
                TestPipes.writeInputFile(FileSystem.get((Configuration)clusterConf), inputPath);
                TestPipes.runProgram(TestPipesAsDifferentUser.this.mrCluster, TestPipesAsDifferentUser.this.dfsCluster, TestPipes.wordCountSimple, inputPath, outputPath, 3, 2, TestPipes.twoSplitOutput, clusterConf);
                TestPipesAsDifferentUser.this.assertOwnerShip(outputPath);
                TestPipes.cleanup(TestPipesAsDifferentUser.this.dfsCluster.getFileSystem(), outputPath);
                TestPipes.runProgram(TestPipesAsDifferentUser.this.mrCluster, TestPipesAsDifferentUser.this.dfsCluster, TestPipes.wordCountSimple, inputPath, outputPath, 3, 0, TestPipes.noSortOutput, clusterConf);
                TestPipesAsDifferentUser.this.assertOwnerShip(outputPath);
                TestPipes.cleanup(TestPipesAsDifferentUser.this.dfsCluster.getFileSystem(), outputPath);
                TestPipes.runProgram(TestPipesAsDifferentUser.this.mrCluster, TestPipesAsDifferentUser.this.dfsCluster, TestPipes.wordCountPart, inputPath, outputPath, 3, 2, TestPipes.fixedPartitionOutput, clusterConf);
                TestPipesAsDifferentUser.this.assertOwnerShip(outputPath);
                TestPipes.cleanup(TestPipesAsDifferentUser.this.dfsCluster.getFileSystem(), outputPath);
                TestPipes.runNonPipedProgram(TestPipesAsDifferentUser.this.mrCluster, TestPipesAsDifferentUser.this.dfsCluster, TestPipes.wordCountNoPipes, clusterConf);
                TestPipesAsDifferentUser.this.assertOwnerShip(TestPipes.nonPipedOutDir, (FileSystem)FileSystem.getLocal((Configuration)clusterConf));
                return null;
            }
        });
    }
}

