/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.File;
import java.io.IOException;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.TaskRunner;

public class TestSetupWorkDir
extends TestCase {
    static void createSubDirsAndSymLinks(JobConf jobConf, Path dir1, Path dir2) throws IOException {
        LocalFileSystem fs = FileSystem.getLocal((Configuration)jobConf);
        TestSetupWorkDir.createSubDirAndFile((FileSystem)fs, dir1);
        TestSetupWorkDir.createSubDirAndFile((FileSystem)fs, dir2);
        FileUtil.symLink((String)(dir2 + "/subDir"), (String)(dir1 + "/symlinkSubDir"));
        FileUtil.symLink((String)(dir2 + "/file"), (String)(dir1 + "/symlinkFile"));
    }

    static void createSubDirAndFile(FileSystem fs, Path dir) throws IOException {
        Path subDir = new Path(dir, "subDir");
        fs.mkdirs(subDir);
        Path p = new Path(dir, "file");
        FSDataOutputStream out = fs.create(p);
        out.writeBytes("dummy input");
        out.close();
    }

    void createEmptyDir(FileSystem fs, Path dir) throws IOException {
        if (fs.exists(dir)) {
            fs.delete(dir, true);
        }
        if (!fs.mkdirs(dir)) {
            throw new IOException("Unable to create directory " + dir);
        }
    }

    public void testSetupWorkDir() throws IOException {
        Path rootDir = new Path(System.getProperty("test.build.data", "/tmp"), "testSetupWorkDir");
        Path myWorkDir = new Path(rootDir, "./work");
        Path myTargetDir = new Path(rootDir, "./tmp");
        JobConf jConf = new JobConf();
        LocalFileSystem fs = FileSystem.getLocal((Configuration)jConf);
        this.createEmptyDir((FileSystem)fs, myWorkDir);
        this.createEmptyDir((FileSystem)fs, myTargetDir);
        TestSetupWorkDir.createSubDirsAndSymLinks(jConf, myWorkDir, myTargetDir);
        TestSetupWorkDir.assertTrue((String)("Did not create symlinks/files/dirs properly. Check " + myWorkDir + " and " + myTargetDir), (fs.listStatus(myWorkDir).length == 4 && fs.listStatus(myTargetDir).length == 2 ? 1 : 0) != 0);
        jConf.set("mapred.create.symlink", "no");
        TaskRunner.setupWorkDir((JobConf)jConf, (File)new File(myWorkDir.toUri().getPath()));
        TestSetupWorkDir.assertTrue((String)(myWorkDir + " is not cleaned up properly."), (fs.exists(myWorkDir) && fs.listStatus(myWorkDir).length == 1 ? 1 : 0) != 0);
        TestSetupWorkDir.assertTrue((boolean)fs.listStatus(myWorkDir)[0].getPath().toUri().getPath().toString().equals(myWorkDir.toString() + "/tmp"));
        TestSetupWorkDir.assertTrue((String)("Dir " + myTargetDir + " seem to be modified."), (fs.exists(myTargetDir) && fs.listStatus(myTargetDir).length == 2 ? 1 : 0) != 0);
        fs.delete(rootDir, true);
    }
}

