/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import junit.framework.Assert;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.examples.SleepJob;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.ClusterWithLinuxTaskController;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.mapred.TestMiniMRChildTask;
import org.apache.hadoop.mapred.UtilsForTests;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class TestJobExecutionAsDifferentUser
extends ClusterWithLinuxTaskController {
    public void testJobExecution() throws Exception {
        if (!TestJobExecutionAsDifferentUser.shouldRun()) {
            return;
        }
        this.startCluster();
        this.jobOwner.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws Exception {
                Path inDir = new Path("input");
                Path outDir = new Path("output");
                RunningJob job = UtilsForTests.runJob(TestJobExecutionAsDifferentUser.this.getClusterConf(), inDir, outDir, 0, 0);
                job.waitForCompletion();
                Assert.assertTrue((String)"Job failed", (boolean)job.isSuccessful());
                TestJobExecutionAsDifferentUser.this.assertOwnerShip(outDir);
                job = UtilsForTests.runJob(TestJobExecutionAsDifferentUser.this.getClusterConf(), inDir, outDir, 1, 0);
                job.waitForCompletion();
                Assert.assertTrue((String)"Job failed", (boolean)job.isSuccessful());
                TestJobExecutionAsDifferentUser.this.assertOwnerShip(outDir);
                job = UtilsForTests.runJob(TestJobExecutionAsDifferentUser.this.getClusterConf(), inDir, outDir, 1, 1);
                job.waitForCompletion();
                Assert.assertTrue((String)"Job failed", (boolean)job.isSuccessful());
                TestJobExecutionAsDifferentUser.this.assertOwnerShip(outDir);
                JobConf myConf = TestJobExecutionAsDifferentUser.this.getClusterConf();
                myConf.set("mapred.job.reuse.jvm.num.tasks", "-1");
                String[] args = new String[]{"-m", "6", "-r", "3", "-mt", "1000", "-rt", "1000"};
                Assert.assertEquals((int)0, (int)ToolRunner.run((Configuration)myConf, (Tool)new SleepJob(), (String[])args));
                return null;
            }
        });
    }

    public void testEnvironment() throws Exception {
        if (!TestJobExecutionAsDifferentUser.shouldRun()) {
            return;
        }
        this.startCluster();
        this.jobOwner.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object run() throws Exception {
                TestMiniMRChildTask childTask = new TestMiniMRChildTask();
                Path inDir = new Path("input1");
                Path outDir = new Path("output1");
                try {
                    childTask.runTestTaskEnv(TestJobExecutionAsDifferentUser.this.getClusterConf(), inDir, outDir, false);
                }
                catch (IOException e) {
                    Assert.fail((String)("IOException thrown while running enviroment test." + e.getMessage()));
                }
                finally {
                    FileSystem outFs = outDir.getFileSystem((Configuration)TestJobExecutionAsDifferentUser.this.getClusterConf());
                    if (outFs.exists(outDir)) {
                        TestJobExecutionAsDifferentUser.this.assertOwnerShip(outDir);
                        outFs.delete(outDir, true);
                    } else {
                        Assert.fail((String)("Output directory does not exist" + outDir.toString()));
                    }
                    return null;
                }
            }
        });
    }
}

