/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import java.io.Writer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.ClusterMapReduceTestCase;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobPriority;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.hadoop.mapred.TextOutputFormat;
import org.apache.hadoop.mapred.lib.IdentityMapper;
import org.apache.hadoop.mapred.lib.IdentityReducer;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class TestJobClient
extends ClusterMapReduceTestCase {
    private static final Log LOG = LogFactory.getLog(TestJobClient.class);

    private String runJob() throws Exception {
        FSDataOutputStream os = this.getFileSystem().create(new Path(this.getInputDir(), "text.txt"));
        OutputStreamWriter wr = new OutputStreamWriter((OutputStream)os);
        wr.write("hello1\n");
        wr.write("hello2\n");
        wr.write("hello3\n");
        ((Writer)wr).close();
        JobConf conf = this.createJobConf();
        conf.setJobName("mr");
        conf.setJobPriority(JobPriority.HIGH);
        conf.setInputFormat(TextInputFormat.class);
        conf.setMapOutputKeyClass(LongWritable.class);
        conf.setMapOutputValueClass(Text.class);
        conf.setOutputFormat(TextOutputFormat.class);
        conf.setOutputKeyClass(LongWritable.class);
        conf.setOutputValueClass(Text.class);
        conf.setMapperClass(IdentityMapper.class);
        conf.setReducerClass(IdentityReducer.class);
        FileInputFormat.setInputPaths((JobConf)conf, (Path[])new Path[]{this.getInputDir()});
        FileOutputFormat.setOutputPath((JobConf)conf, (Path)this.getOutputDir());
        return JobClient.runJob((JobConf)conf).getID().toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int runTool(Configuration conf, Tool tool, String[] args, OutputStream out) throws Exception {
        PrintStream oldOut = System.out;
        PrintStream newOut = new PrintStream(out, true);
        try {
            System.setOut(newOut);
            int n = ToolRunner.run((Configuration)conf, (Tool)tool, (String[])args);
            return n;
        }
        finally {
            System.setOut(oldOut);
        }
    }

    public void testGetCounter() throws Exception {
        String jobId = this.runJob();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int exitCode = this.runTool((Configuration)this.createJobConf(), (Tool)new JobClient(), new String[]{"-counter", jobId, "org.apache.hadoop.mapred.Task$Counter", "MAP_INPUT_RECORDS"}, out);
        TestJobClient.assertEquals((String)"Exit code", (int)0, (int)exitCode);
        TestJobClient.assertEquals((String)"Counter", (String)"3", (String)out.toString().trim());
    }

    public void testJobList() throws Exception {
        String jobId = this.runJob();
        this.verifyJobPriority(jobId, "HIGH");
    }

    private void verifyJobPriority(String jobId, String priority) throws Exception {
        PipedInputStream pis = new PipedInputStream();
        PipedOutputStream pos = new PipedOutputStream(pis);
        int exitCode = this.runTool((Configuration)this.createJobConf(), (Tool)new JobClient(), new String[]{"-list", "all"}, pos);
        TestJobClient.assertEquals((String)"Exit code", (int)0, (int)exitCode);
        BufferedReader br = new BufferedReader(new InputStreamReader(pis));
        String line = null;
        while ((line = br.readLine()) != null) {
            LOG.info((Object)("line = " + line));
            if (!line.startsWith(jobId)) continue;
            TestJobClient.assertTrue((boolean)line.contains(priority));
            break;
        }
        pis.close();
    }

    public void testChangingJobPriority() throws Exception {
        String jobId = this.runJob();
        int exitCode = this.runTool((Configuration)this.createJobConf(), (Tool)new JobClient(), new String[]{"-set-priority", jobId, "VERY_LOW"}, new ByteArrayOutputStream());
        TestJobClient.assertEquals((String)"Exit code", (int)0, (int)exitCode);
        this.verifyJobPriority(jobId, "VERY_LOW");
    }
}

