/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import junit.framework.TestCase;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.JobConf;

public class TestInputPath
extends TestCase {
    public void testInputPath() throws Exception {
        JobConf jobConf = new JobConf();
        Path workingDir = jobConf.getWorkingDirectory();
        Path path = new Path(workingDir, "xx{y,z}");
        FileInputFormat.setInputPaths((JobConf)jobConf, (Path[])new Path[]{path});
        Path[] paths = FileInputFormat.getInputPaths((JobConf)jobConf);
        TestInputPath.assertEquals((int)1, (int)paths.length);
        TestInputPath.assertEquals((String)path.toString(), (String)paths[0].toString());
        StringBuilder pathStr = new StringBuilder();
        pathStr.append('\\');
        pathStr.append('\\');
        pathStr.append(',');
        pathStr.append(',');
        pathStr.append('a');
        path = new Path(workingDir, pathStr.toString());
        FileInputFormat.setInputPaths((JobConf)jobConf, (Path[])new Path[]{path});
        paths = FileInputFormat.getInputPaths((JobConf)jobConf);
        TestInputPath.assertEquals((int)1, (int)paths.length);
        TestInputPath.assertEquals((String)path.toString(), (String)paths[0].toString());
        pathStr.setLength(0);
        pathStr.append('\\');
        pathStr.append("xx");
        pathStr.append('\\');
        path = new Path(workingDir, pathStr.toString());
        Path path1 = new Path(workingDir, "yy,zz");
        FileInputFormat.setInputPaths((JobConf)jobConf, (Path[])new Path[]{path});
        FileInputFormat.addInputPath((JobConf)jobConf, (Path)path1);
        paths = FileInputFormat.getInputPaths((JobConf)jobConf);
        TestInputPath.assertEquals((int)2, (int)paths.length);
        TestInputPath.assertEquals((String)path.toString(), (String)paths[0].toString());
        TestInputPath.assertEquals((String)path1.toString(), (String)paths[1].toString());
        FileInputFormat.setInputPaths((JobConf)jobConf, (Path[])new Path[]{path, path1});
        paths = FileInputFormat.getInputPaths((JobConf)jobConf);
        TestInputPath.assertEquals((int)2, (int)paths.length);
        TestInputPath.assertEquals((String)path.toString(), (String)paths[0].toString());
        TestInputPath.assertEquals((String)path1.toString(), (String)paths[1].toString());
        Path[] input = new Path[]{path, path1};
        FileInputFormat.setInputPaths((JobConf)jobConf, (Path[])input);
        paths = FileInputFormat.getInputPaths((JobConf)jobConf);
        TestInputPath.assertEquals((int)2, (int)paths.length);
        TestInputPath.assertEquals((String)path.toString(), (String)paths[0].toString());
        TestInputPath.assertEquals((String)path1.toString(), (String)paths[1].toString());
        pathStr.setLength(0);
        String str1 = "{a{b,c},de}";
        String str2 = "xyz";
        String str3 = "x{y,z}";
        pathStr.append(str1);
        pathStr.append(',');
        pathStr.append(str2);
        pathStr.append(',');
        pathStr.append(str3);
        FileInputFormat.setInputPaths((JobConf)jobConf, (String)pathStr.toString());
        paths = FileInputFormat.getInputPaths((JobConf)jobConf);
        TestInputPath.assertEquals((int)3, (int)paths.length);
        TestInputPath.assertEquals((String)new Path(workingDir, str1).toString(), (String)paths[0].toString());
        TestInputPath.assertEquals((String)new Path(workingDir, str2).toString(), (String)paths[1].toString());
        TestInputPath.assertEquals((String)new Path(workingDir, str3).toString(), (String)paths[2].toString());
        pathStr.setLength(0);
        String str4 = "abc";
        String str5 = "pq{r,s}";
        pathStr.append(str4);
        pathStr.append(',');
        pathStr.append(str5);
        FileInputFormat.addInputPaths((JobConf)jobConf, (String)pathStr.toString());
        paths = FileInputFormat.getInputPaths((JobConf)jobConf);
        TestInputPath.assertEquals((int)5, (int)paths.length);
        TestInputPath.assertEquals((String)new Path(workingDir, str1).toString(), (String)paths[0].toString());
        TestInputPath.assertEquals((String)new Path(workingDir, str2).toString(), (String)paths[1].toString());
        TestInputPath.assertEquals((String)new Path(workingDir, str3).toString(), (String)paths[2].toString());
        TestInputPath.assertEquals((String)new Path(workingDir, str4).toString(), (String)paths[3].toString());
        TestInputPath.assertEquals((String)new Path(workingDir, str5).toString(), (String)paths[4].toString());
    }
}

