/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.Counters;
import org.apache.hadoop.mapred.IFile;
import org.apache.hadoop.mapred.Task;
import org.apache.hadoop.util.Progressable;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestCombineOutputCollector {
    private Task.CombineOutputCollector<String, Integer> coc;

    @Test
    public void testCustomCollect() throws Throwable {
        Task.TaskReporter mockTaskReporter = (Task.TaskReporter)Mockito.mock(Task.TaskReporter.class);
        Counters.Counter outCounter = new Counters.Counter();
        IFile.Writer mockWriter = (IFile.Writer)Mockito.mock(IFile.Writer.class);
        Configuration conf = new Configuration();
        conf.set("mapred.combine.recordsBeforeProgress", "2");
        this.coc = new Task.CombineOutputCollector(outCounter, (Progressable)mockTaskReporter, conf);
        this.coc.setWriter(mockWriter);
        ((Task.TaskReporter)Mockito.verify((Object)mockTaskReporter, (VerificationMode)Mockito.never())).progress();
        this.coc.collect((Object)"dummy", (Object)1);
        ((Task.TaskReporter)Mockito.verify((Object)mockTaskReporter, (VerificationMode)Mockito.never())).progress();
        this.coc.collect((Object)"dummy", (Object)2);
        ((Task.TaskReporter)Mockito.verify((Object)mockTaskReporter, (VerificationMode)Mockito.times((int)1))).progress();
    }

    @Test
    public void testDefaultCollect() throws Throwable {
        Task.TaskReporter mockTaskReporter = (Task.TaskReporter)Mockito.mock(Task.TaskReporter.class);
        Counters.Counter outCounter = new Counters.Counter();
        IFile.Writer mockWriter = (IFile.Writer)Mockito.mock(IFile.Writer.class);
        Configuration conf = new Configuration();
        this.coc = new Task.CombineOutputCollector(outCounter, (Progressable)mockTaskReporter, conf);
        this.coc.setWriter(mockWriter);
        ((Task.TaskReporter)Mockito.verify((Object)mockTaskReporter, (VerificationMode)Mockito.never())).progress();
        int i = 0;
        while ((long)i < 10000L) {
            this.coc.collect((Object)"dummy", (Object)i);
            ++i;
        }
        ((Task.TaskReporter)Mockito.verify((Object)mockTaskReporter, (VerificationMode)Mockito.times((int)1))).progress();
        i = 0;
        while ((long)i < 10000L) {
            this.coc.collect((Object)"dummy", (Object)i);
            ++i;
        }
        ((Task.TaskReporter)Mockito.verify((Object)mockTaskReporter, (VerificationMode)Mockito.times((int)2))).progress();
    }
}

