/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.tools.offlineImageViewer;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.FSConstants;
import org.apache.hadoop.hdfs.tools.offlineImageViewer.FileDistributionVisitor;
import org.apache.hadoop.hdfs.tools.offlineImageViewer.ImageVisitor;
import org.apache.hadoop.hdfs.tools.offlineImageViewer.LsImageVisitor;
import org.apache.hadoop.hdfs.tools.offlineImageViewer.OfflineImageViewer;
import org.apache.hadoop.security.token.Token;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestOfflineImageViewer {
    private static final Log LOG = LogFactory.getLog(OfflineImageViewer.class);
    private static final int NUM_DIRS = 3;
    private static final int FILES_PER_DIR = 4;
    private static final String TEST_RENEWER = "JobTracker";
    private static File originalFsimage = null;
    static final HashMap<String, FileStatus> writtenFiles = new HashMap();
    private static String ROOT = System.getProperty("test.build.data", "build/test/data");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @BeforeClass
    public static void createOriginalFSImage() throws IOException {
        MiniDFSCluster cluster = null;
        try {
            Configuration conf = new Configuration();
            conf.setLong("dfs.namenode.delegation.token.max-lifetime", 10000L);
            conf.setLong("dfs.namenode.delegation.token.renew-interval", 5000L);
            conf.setBoolean("dfs.namenode.delegation.token.always-use", true);
            conf.set("hadoop.security.auth_to_local", "RULE:[2:$1@$0](JobTracker@.*FOO.COM)s/@.*//DEFAULT");
            cluster = new MiniDFSCluster(conf, 4, true, null);
            cluster.waitActive();
            FileSystem hdfs = cluster.getFileSystem();
            int filesize = 256;
            for (int i = 0; i < 3; ++i) {
                Path dir = new Path("/dir" + i);
                hdfs.mkdirs(dir);
                writtenFiles.put(dir.toString(), TestOfflineImageViewer.pathToFileEntry(hdfs, dir.toString()));
                for (int j = 0; j < 4; ++j) {
                    Path file = new Path(dir, "file" + j);
                    FSDataOutputStream o = hdfs.create(file);
                    o.write(new byte[filesize++]);
                    o.close();
                    writtenFiles.put(file.toString(), TestOfflineImageViewer.pathToFileEntry(hdfs, file.toString()));
                }
            }
            Token delegationToken = hdfs.getDelegationToken(TEST_RENEWER);
            LOG.debug((Object)("got token " + delegationToken));
            cluster.getNameNode().setSafeMode(FSConstants.SafeModeAction.SAFEMODE_ENTER);
            cluster.getNameNode().saveNamespace();
            File[] files = cluster.getNameDirs().toArray(new File[0]);
            originalFsimage = new File(files[0], "current/fsimage");
            if (!originalFsimage.exists()) {
                Assert.fail((String)"Didn't generate or can't find fsimage.");
            }
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    @AfterClass
    public static void deleteOriginalFSImage() throws IOException {
        if (originalFsimage != null && originalFsimage.exists()) {
            originalFsimage.delete();
        }
    }

    private static FileStatus pathToFileEntry(FileSystem hdfs, String file) throws IOException {
        return hdfs.getFileStatus(new Path(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void outputOfLSVisitor() throws IOException {
        File testFile = new File(ROOT, "/basicCheck");
        File outputFile = new File(ROOT, "/basicCheckOutput");
        try {
            this.copyFile(originalFsimage, testFile);
            LsImageVisitor v = new LsImageVisitor(outputFile.getPath(), true);
            OfflineImageViewer oiv = new OfflineImageViewer(testFile.getPath(), (ImageVisitor)v, false);
            oiv.go();
            HashMap<String, LsElements> fileOutput = this.readLsfile(outputFile);
            this.compareNamespaces(writtenFiles, fileOutput);
        }
        finally {
            if (testFile.exists()) {
                testFile.delete();
            }
            if (outputFile.exists()) {
                outputFile.delete();
            }
        }
        LOG.debug((Object)"Correctly generated ls-style output.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void unsupportedFSLayoutVersion() throws IOException {
        File testFile = new File(ROOT, "/invalidLayoutVersion");
        File outputFile = new File(ROOT, "invalidLayoutVersionOutput");
        try {
            int badVersionNum = -432;
            this.changeLayoutVersion(originalFsimage, testFile, badVersionNum);
            LsImageVisitor v = new LsImageVisitor(outputFile.getPath(), true);
            OfflineImageViewer oiv = new OfflineImageViewer(testFile.getPath(), (ImageVisitor)v, false);
            try {
                oiv.go();
                Assert.fail((String)"Shouldn't be able to read invalid laytout version");
            }
            catch (IOException e) {
                if (!e.getMessage().contains(Integer.toString(badVersionNum))) {
                    throw e;
                }
                LOG.debug((Object)"Correctly failed at reading bad image version.");
            }
        }
        finally {
            if (testFile.exists()) {
                testFile.delete();
            }
            if (outputFile.exists()) {
                outputFile.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void truncatedFSImage() throws IOException {
        File testFile = new File(ROOT, "/truncatedFSImage");
        File outputFile = new File(ROOT, "/trucnatedFSImageOutput");
        try {
            this.copyPartOfFile(originalFsimage, testFile);
            Assert.assertTrue((String)"Created truncated fsimage", (boolean)testFile.exists());
            LsImageVisitor v = new LsImageVisitor(outputFile.getPath(), true);
            OfflineImageViewer oiv = new OfflineImageViewer(testFile.getPath(), (ImageVisitor)v, false);
            try {
                oiv.go();
                Assert.fail((String)"Managed to process a truncated fsimage file");
            }
            catch (EOFException e) {
                LOG.debug((Object)"Correctly handled EOF");
            }
        }
        finally {
            if (testFile.exists()) {
                testFile.delete();
            }
            if (outputFile.exists()) {
                outputFile.delete();
            }
        }
    }

    private void compareNamespaces(HashMap<String, FileStatus> written, HashMap<String, LsElements> fileOutput) {
        Assert.assertEquals((String)"Should be the same number of files in both, plus one for root in fileoutput", (long)fileOutput.keySet().size(), (long)(written.keySet().size() + 1));
        Set<String> inFile = fileOutput.keySet();
        for (String path : inFile) {
            if (path.equals("/")) continue;
            Assert.assertTrue((String)("Path in file (" + path + ") was written to fs"), (boolean)written.containsKey(path));
            this.compareFiles(written.get(path), fileOutput.get(path));
            written.remove(path);
        }
        Assert.assertEquals((String)"No more files were written to fs", (long)0L, (long)written.size());
    }

    private void compareFiles(FileStatus fs, LsElements elements) {
        Assert.assertEquals((String)"directory listed as such", (long)(fs.isDir() ? 100L : 45L), (long)elements.dir);
        Assert.assertEquals((String)"perms string equal", (Object)fs.getPermission().toString(), (Object)elements.perms);
        Assert.assertEquals((String)"replication equal", (long)fs.getReplication(), (long)elements.replication);
        Assert.assertEquals((String)"owner equal", (Object)fs.getOwner(), (Object)elements.username);
        Assert.assertEquals((String)"group equal", (Object)fs.getGroup(), (Object)elements.groupname);
        Assert.assertEquals((String)"lengths equal", (long)fs.getLen(), (long)elements.filesize);
    }

    private HashMap<String, LsElements> readLsfile(File lsFile) throws IOException {
        BufferedReader br = new BufferedReader(new FileReader(lsFile));
        String line = null;
        HashMap<String, LsElements> fileContents = new HashMap<String, LsElements>();
        while ((line = br.readLine()) != null) {
            this.readLsLine(line, fileContents);
        }
        return fileContents;
    }

    private void readLsLine(String line, HashMap<String, LsElements> fileContents) {
        String[] elements = line.split("\\s+");
        Assert.assertEquals((String)"Not enough elements in ls output", (long)8L, (long)elements.length);
        LsElements lsLine = new LsElements();
        lsLine.dir = elements[0].charAt(0);
        lsLine.perms = elements[0].substring(1);
        lsLine.replication = elements[1].equals("-") ? 0 : Integer.valueOf(elements[1]);
        lsLine.username = elements[2];
        lsLine.groupname = elements[3];
        lsLine.filesize = Long.valueOf(elements[4]);
        String path = elements[7];
        Assert.assertFalse((String)"LS file had duplicate file entries", (boolean)fileContents.containsKey(path));
        fileContents.put(path, lsLine);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changeLayoutVersion(File src, File dest, int newVersion) throws IOException {
        FilterInputStream in = null;
        FilterOutputStream out = null;
        try {
            in = new DataInputStream(new FileInputStream(src));
            out = new DataOutputStream(new FileOutputStream(dest));
            ((DataInputStream)in).readInt();
            ((DataOutputStream)out).writeInt(newVersion);
            byte[] b = new byte[1024];
            while (((DataInputStream)in).read(b) > 0) {
                out.write(b);
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (out != null) {
                out.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyPartOfFile(File src, File dest) throws IOException {
        FileInputStream in = null;
        OutputStream out = null;
        byte[] b = new byte[256];
        int maxBytes = 700;
        try {
            int count;
            in = new FileInputStream(src);
            out = new FileOutputStream(dest);
            for (int bytesWritten = 0; (count = ((InputStream)in).read(b)) > 0 && bytesWritten < maxBytes; bytesWritten += count) {
                out.write(b);
            }
        }
        finally {
            if (in != null) {
                ((InputStream)in).close();
            }
            if (out != null) {
                out.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyFile(File src, File dest) throws IOException {
        FileInputStream in = null;
        OutputStream out = null;
        try {
            in = new FileInputStream(src);
            out = new FileOutputStream(dest);
            byte[] b = new byte[1024];
            while (((InputStream)in).read(b) > 0) {
                out.write(b);
            }
        }
        finally {
            if (in != null) {
                ((InputStream)in).close();
            }
            if (out != null) {
                out.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void outputOfFileDistributionVisitor() throws IOException {
        File testFile = new File(ROOT, "/basicCheck");
        File outputFile = new File(ROOT, "/fileDistributionCheckOutput");
        int totalFiles = 0;
        try {
            this.copyFile(originalFsimage, testFile);
            FileDistributionVisitor v = new FileDistributionVisitor(outputFile.getPath(), 0L, 0);
            OfflineImageViewer oiv = new OfflineImageViewer(testFile.getPath(), (ImageVisitor)v, false);
            oiv.go();
            BufferedReader reader = new BufferedReader(new FileReader(outputFile));
            String line = reader.readLine();
            Assert.assertEquals((Object)line, (Object)"Size\tNumFiles");
            while ((line = reader.readLine()) != null) {
                String[] row = line.split("\t");
                Assert.assertEquals((long)row.length, (long)2L);
                totalFiles += Integer.parseInt(row[1]);
            }
        }
        finally {
            if (testFile.exists()) {
                testFile.delete();
            }
            if (outputFile.exists()) {
                outputFile.delete();
            }
        }
        Assert.assertEquals((long)totalFiles, (long)12L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void outputOfTestVisitor() throws IOException {
        File testFile = new File(ROOT, "/basicCheck");
        try {
            this.copyFile(originalFsimage, testFile);
            TestImageVisitor v = new TestImageVisitor();
            OfflineImageViewer oiv = new OfflineImageViewer(testFile.getPath(), (ImageVisitor)v, true);
            oiv.go();
            List<String> dtrs = v.getDelegationTokenRenewers();
            Assert.assertEquals((long)1L, (long)dtrs.size());
            Assert.assertEquals((Object)TEST_RENEWER, (Object)dtrs.get(0));
        }
        finally {
            if (testFile.exists()) {
                testFile.delete();
            }
        }
        LOG.debug((Object)"Passed TestVisitor validation.");
    }

    private static class TestImageVisitor
    extends ImageVisitor {
        private List<String> delegationTokenRenewers = new LinkedList<String>();

        TestImageVisitor() {
        }

        List<String> getDelegationTokenRenewers() {
            return this.delegationTokenRenewers;
        }

        void start() throws IOException {
        }

        void finish() throws IOException {
        }

        void finishAbnormally() throws IOException {
        }

        void visit(ImageVisitor.ImageElement element, String value) throws IOException {
            if (element == ImageVisitor.ImageElement.DELEGATION_TOKEN_IDENTIFIER_RENEWER) {
                this.delegationTokenRenewers.add(value);
            }
        }

        void visitEnclosingElement(ImageVisitor.ImageElement element) throws IOException {
        }

        void visitEnclosingElement(ImageVisitor.ImageElement element, ImageVisitor.ImageElement key, String value) throws IOException {
        }

        void leaveEnclosingElement() throws IOException {
        }
    }

    private static class LsElements {
        public String perms;
        public int replication;
        public String username;
        public String groupname;
        public long filesize;
        public char dir;

        private LsElements() {
        }
    }
}

