/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.net.InetSocketAddress;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.junit.Assert;
import org.junit.Test;

public class TestDefaultNameNodePort {
    @Test
    public void testGetAddressFromString() throws Exception {
        Assert.assertEquals((long)NameNode.getAddress((String)"foo").getPort(), (long)8020L);
        Assert.assertEquals((long)NameNode.getAddress((String)"hdfs://foo/").getPort(), (long)8020L);
        Assert.assertEquals((long)NameNode.getAddress((String)"hdfs://foo:555").getPort(), (long)555L);
        Assert.assertEquals((long)NameNode.getAddress((String)"foo:555").getPort(), (long)555L);
    }

    @Test
    public void testGetAddressFromConf() throws Exception {
        Configuration conf = new Configuration();
        FileSystem.setDefaultUri((Configuration)conf, (String)"hdfs://foo/");
        Assert.assertEquals((long)NameNode.getAddress((Configuration)conf).getPort(), (long)8020L);
        FileSystem.setDefaultUri((Configuration)conf, (String)"hdfs://foo:555/");
        Assert.assertEquals((long)NameNode.getAddress((Configuration)conf).getPort(), (long)555L);
        FileSystem.setDefaultUri((Configuration)conf, (String)"foo");
        Assert.assertEquals((long)NameNode.getAddress((Configuration)conf).getPort(), (long)8020L);
        conf.set("dfs.namenode.rpc-address", "hdfs://bar:222");
        Assert.assertEquals((Object)"bar", (Object)NameNode.getAddress((Configuration)conf).getHostName());
        Assert.assertEquals((long)222L, (long)NameNode.getAddress((Configuration)conf).getPort());
        conf.set("dfs.namenode.rpc-address", "");
        Assert.assertEquals((long)NameNode.getAddress((Configuration)conf).getPort(), (long)8020L);
    }

    public void testGetUri() {
        Assert.assertEquals((Object)NameNode.getUri((InetSocketAddress)new InetSocketAddress("foo", 555)), (Object)URI.create("hdfs://foo:555"));
        Assert.assertEquals((Object)NameNode.getUri((InetSocketAddress)new InetSocketAddress("foo", 8020)), (Object)URI.create("hdfs://foo"));
    }

    @Test
    public void testSlashAddress() throws Exception {
        this.verifyBadAuthAddress("/junk");
    }

    @Test
    public void testSlashSlashAddress() throws Exception {
        this.verifyBadAuthAddress("//junk");
    }

    @Test
    public void testNoAuthAddress() throws Exception {
        this.verifyBadAuthAddress("file:///");
    }

    public void verifyBadAuthAddress(String noAuth) throws Exception {
        Configuration conf = new Configuration();
        FileSystem.setDefaultUri((Configuration)conf, (String)noAuth);
        try {
            InetSocketAddress addr = NameNode.getAddress((Configuration)conf);
            Assert.assertEquals(null, (Object)addr);
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)("Does not contain a valid host:port authority: " + noAuth), (Object)e.getMessage());
        }
    }
}

