/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Random;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.DataTransferProtocol;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.FSConstants;
import org.apache.hadoop.hdfs.security.token.block.BlockTokenSecretManager;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.net.NetUtils;

public class TestDataTransferProtocol
extends TestCase {
    private static final Log LOG = LogFactory.getLog((String)"org.apache.hadoop.hdfs.TestDataTransferProtocol");
    DatanodeID datanode;
    InetSocketAddress dnAddr;
    ByteArrayOutputStream sendBuf = new ByteArrayOutputStream(128);
    DataOutputStream sendOut = new DataOutputStream(this.sendBuf);
    ByteArrayOutputStream recvBuf = new ByteArrayOutputStream(128);
    DataOutputStream recvOut = new DataOutputStream(this.recvBuf);

    /*
     * Exception decompiling
     */
    private void sendRecvData(String testDescription, boolean eofExpected) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK], 3[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    void createFile(FileSystem fs, Path path, int fileLen) throws IOException {
        byte[] arr = new byte[fileLen];
        FSDataOutputStream out = fs.create(path);
        out.write(arr);
        out.close();
    }

    void readFile(FileSystem fs, Path path, int fileLen) throws IOException {
        byte[] arr = new byte[fileLen];
        FSDataInputStream in = fs.open(path);
        in.readFully(arr);
    }

    public void testDataTransferProtocol() throws IOException {
        Random random = new Random();
        int oneMil = 0x100000;
        Path file = new Path("dataprotocol.dat");
        int numDataNodes = 1;
        Configuration conf = new Configuration();
        conf.setInt("dfs.replication", numDataNodes);
        MiniDFSCluster cluster = new MiniDFSCluster(conf, numDataNodes, true, null);
        cluster.waitActive();
        DFSClient dfsClient = new DFSClient(new InetSocketAddress("localhost", cluster.getNameNodePort()), conf);
        this.datanode = dfsClient.datanodeReport(FSConstants.DatanodeReportType.LIVE)[0];
        this.dnAddr = NetUtils.createSocketAddr((String)this.datanode.getName());
        FileSystem fileSys = cluster.getFileSystem();
        int fileLen = Math.min(conf.getInt("dfs.block.size", 4096), 4096);
        this.createFile(fileSys, file, fileLen);
        Block firstBlock = DFSTestUtil.getFirstBlock(fileSys, file);
        long newBlockId = firstBlock.getBlockId() + 1L;
        this.recvBuf.reset();
        this.sendBuf.reset();
        this.recvOut.writeShort(16);
        this.sendOut.writeShort(16);
        this.sendRecvData("Wrong Version", true);
        this.sendBuf.reset();
        this.sendOut.writeShort(17);
        this.sendOut.writeByte(79);
        this.sendRecvData("Wrong Op Code", true);
        this.sendBuf.reset();
        this.sendOut.writeShort(17);
        this.sendOut.writeByte(80);
        this.sendOut.writeLong(newBlockId);
        this.sendOut.writeLong(0L);
        this.sendOut.writeInt(0);
        this.sendOut.writeBoolean(false);
        Text.writeString((DataOutput)this.sendOut, (String)"cl");
        this.sendOut.writeBoolean(false);
        this.sendOut.writeInt(0);
        BlockTokenSecretManager.DUMMY_TOKEN.write((DataOutput)this.sendOut);
        this.sendOut.writeByte(1);
        this.sendOut.writeInt(-1 - random.nextInt(oneMil));
        this.recvBuf.reset();
        this.recvOut.writeShort(1);
        this.sendRecvData("wrong bytesPerChecksum while writing", true);
        this.sendBuf.reset();
        this.recvBuf.reset();
        this.sendOut.writeShort(17);
        this.sendOut.writeByte(80);
        this.sendOut.writeLong(newBlockId);
        this.sendOut.writeLong(0L);
        this.sendOut.writeInt(0);
        this.sendOut.writeBoolean(false);
        Text.writeString((DataOutput)this.sendOut, (String)"cl");
        this.sendOut.writeBoolean(false);
        this.sendOut.writeInt(-1 - random.nextInt(oneMil));
        this.recvOut.writeShort(1);
        this.sendRecvData("bad targets len while writing block " + newBlockId, true);
        this.sendBuf.reset();
        this.recvBuf.reset();
        this.sendOut.writeShort(17);
        this.sendOut.writeByte(80);
        this.sendOut.writeLong(++newBlockId);
        this.sendOut.writeLong(0L);
        this.sendOut.writeInt(0);
        this.sendOut.writeBoolean(false);
        Text.writeString((DataOutput)this.sendOut, (String)"cl");
        this.sendOut.writeBoolean(false);
        this.sendOut.writeInt(0);
        BlockTokenSecretManager.DUMMY_TOKEN.write((DataOutput)this.sendOut);
        this.sendOut.writeByte(1);
        this.sendOut.writeInt(512);
        this.sendOut.writeInt(4);
        this.sendOut.writeLong(0L);
        this.sendOut.writeLong(100L);
        this.sendOut.writeBoolean(false);
        this.sendOut.writeInt(-1 - random.nextInt(oneMil));
        this.recvOut.writeShort(0);
        Text.writeString((DataOutput)this.recvOut, (String)"");
        this.recvOut.writeLong(100L);
        this.recvOut.writeShort(1);
        this.sendRecvData("negative DATA_CHUNK len while writing block " + newBlockId, true);
        this.sendBuf.reset();
        this.recvBuf.reset();
        this.sendOut.writeShort(17);
        this.sendOut.writeByte(80);
        this.sendOut.writeLong(++newBlockId);
        this.sendOut.writeLong(0L);
        this.sendOut.writeInt(0);
        this.sendOut.writeBoolean(false);
        Text.writeString((DataOutput)this.sendOut, (String)"cl");
        this.sendOut.writeBoolean(false);
        this.sendOut.writeInt(0);
        BlockTokenSecretManager.DUMMY_TOKEN.write((DataOutput)this.sendOut);
        this.sendOut.writeByte(1);
        this.sendOut.writeInt(512);
        this.sendOut.writeInt(8);
        this.sendOut.writeLong(0L);
        this.sendOut.writeLong(100L);
        this.sendOut.writeBoolean(true);
        this.sendOut.writeInt(0);
        this.sendOut.writeInt(0);
        this.recvOut.writeShort(0);
        Text.writeString((DataOutput)this.recvOut, (String)"");
        new DataTransferProtocol.PipelineAck(100L, new short[]{0}).write((DataOutput)this.recvOut);
        this.sendRecvData("Writing a zero len block blockid " + newBlockId, false);
        this.sendBuf.reset();
        this.recvBuf.reset();
        this.sendOut.writeShort(17);
        this.sendOut.writeByte(81);
        newBlockId = firstBlock.getBlockId() - 1L;
        this.sendOut.writeLong(newBlockId);
        this.sendOut.writeLong(firstBlock.getGenerationStamp());
        this.sendOut.writeLong(0L);
        this.sendOut.writeLong(fileLen);
        this.recvOut.writeShort(1);
        Text.writeString((DataOutput)this.sendOut, (String)"cl");
        BlockTokenSecretManager.DUMMY_TOKEN.write((DataOutput)this.sendOut);
        this.sendRecvData("Wrong block ID " + newBlockId + " for read", false);
        this.sendBuf.reset();
        this.sendOut.writeShort(17);
        this.sendOut.writeByte(81);
        this.sendOut.writeLong(firstBlock.getBlockId());
        this.sendOut.writeLong(firstBlock.getGenerationStamp());
        this.sendOut.writeLong(-1L);
        this.sendOut.writeLong(fileLen);
        Text.writeString((DataOutput)this.sendOut, (String)"cl");
        BlockTokenSecretManager.DUMMY_TOKEN.write((DataOutput)this.sendOut);
        this.sendRecvData("Negative start-offset for read for block " + firstBlock.getBlockId(), false);
        this.sendBuf.reset();
        this.sendOut.writeShort(17);
        this.sendOut.writeByte(81);
        this.sendOut.writeLong(firstBlock.getBlockId());
        this.sendOut.writeLong(firstBlock.getGenerationStamp());
        this.sendOut.writeLong(fileLen);
        this.sendOut.writeLong(fileLen);
        Text.writeString((DataOutput)this.sendOut, (String)"cl");
        BlockTokenSecretManager.DUMMY_TOKEN.write((DataOutput)this.sendOut);
        this.sendRecvData("Wrong start-offset for reading block " + firstBlock.getBlockId(), false);
        this.recvBuf.reset();
        this.recvOut.writeShort(0);
        this.sendBuf.reset();
        this.sendOut.writeShort(17);
        this.sendOut.writeByte(81);
        this.sendOut.writeLong(firstBlock.getBlockId());
        this.sendOut.writeLong(firstBlock.getGenerationStamp());
        this.sendOut.writeLong(0L);
        this.sendOut.writeLong(-1 - random.nextInt(oneMil));
        Text.writeString((DataOutput)this.sendOut, (String)"cl");
        BlockTokenSecretManager.DUMMY_TOKEN.write((DataOutput)this.sendOut);
        this.sendRecvData("Negative length for reading block " + firstBlock.getBlockId(), false);
        this.recvBuf.reset();
        this.recvOut.writeShort(1);
        this.sendBuf.reset();
        this.sendOut.writeShort(17);
        this.sendOut.writeByte(81);
        this.sendOut.writeLong(firstBlock.getBlockId());
        this.sendOut.writeLong(firstBlock.getGenerationStamp());
        this.sendOut.writeLong(0L);
        this.sendOut.writeLong(fileLen + 1);
        Text.writeString((DataOutput)this.sendOut, (String)"cl");
        BlockTokenSecretManager.DUMMY_TOKEN.write((DataOutput)this.sendOut);
        this.sendRecvData("Wrong length for reading block " + firstBlock.getBlockId(), false);
        this.sendBuf.reset();
        this.sendOut.writeShort(17);
        this.sendOut.writeByte(81);
        this.sendOut.writeLong(firstBlock.getBlockId());
        this.sendOut.writeLong(firstBlock.getGenerationStamp());
        this.sendOut.writeLong(0L);
        this.sendOut.writeLong(fileLen);
        Text.writeString((DataOutput)this.sendOut, (String)"cl");
        BlockTokenSecretManager.DUMMY_TOKEN.write((DataOutput)this.sendOut);
        this.readFile(fileSys, file, fileLen);
    }
}

