/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.MiniDFSCluster;

public class TestDFSMkdirs
extends TestCase {
    private void writeFile(FileSystem fileSys, Path name) throws IOException {
        FSDataOutputStream stm = fileSys.create(name);
        stm.writeBytes("wchien");
        stm.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDFSMkdirs() throws IOException {
        Configuration conf = new Configuration();
        MiniDFSCluster cluster = new MiniDFSCluster(conf, 2, true, null);
        FileSystem fileSys = cluster.getFileSystem();
        try {
            Path myPath = new Path("/test/mkdirs");
            TestDFSMkdirs.assertTrue((boolean)fileSys.mkdirs(myPath));
            TestDFSMkdirs.assertTrue((boolean)fileSys.exists(myPath));
            TestDFSMkdirs.assertTrue((boolean)fileSys.mkdirs(myPath));
            Path myFile = new Path("/test/mkdirs/myFile");
            this.writeFile(fileSys, myFile);
            Path myIllegalPath = new Path("/test/mkdirs/myFile/subdir");
            Boolean exist = true;
            try {
                fileSys.mkdirs(myIllegalPath);
            }
            catch (IOException e) {
                exist = false;
            }
            TestDFSMkdirs.assertFalse((boolean)exist);
            TestDFSMkdirs.assertFalse((boolean)fileSys.exists(myIllegalPath));
            fileSys.delete(myFile, true);
        }
        finally {
            fileSys.close();
            cluster.shutdown();
        }
    }
}

