/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;

public class TestPath
extends TestCase {
    public void testToString() {
        this.toStringTest("/");
        this.toStringTest("/foo");
        this.toStringTest("/foo/bar");
        this.toStringTest("foo");
        this.toStringTest("foo/bar");
        this.toStringTest("/foo/bar#boo");
        this.toStringTest("foo/bar#boo");
        boolean emptyException = false;
        try {
            this.toStringTest("");
        }
        catch (IllegalArgumentException e) {
            emptyException = true;
        }
        TestPath.assertTrue((boolean)emptyException);
        if (Path.WINDOWS) {
            this.toStringTest("c:");
            this.toStringTest("c:/");
            this.toStringTest("c:foo");
            this.toStringTest("c:foo/bar");
            this.toStringTest("c:foo/bar");
            this.toStringTest("c:/foo/bar");
            this.toStringTest("C:/foo/bar#boo");
            this.toStringTest("C:foo/bar#boo");
        }
    }

    private void toStringTest(String pathString) {
        TestPath.assertEquals((String)pathString, (String)new Path(pathString).toString());
    }

    public void testNormalize() {
        TestPath.assertEquals((String)"/", (String)new Path("//").toString());
        TestPath.assertEquals((String)"/foo", (String)new Path("/foo/").toString());
        TestPath.assertEquals((String)"/foo", (String)new Path("/foo/").toString());
        TestPath.assertEquals((String)"foo", (String)new Path("foo/").toString());
        TestPath.assertEquals((String)"foo", (String)new Path("foo//").toString());
        TestPath.assertEquals((String)"foo/bar", (String)new Path("foo//bar").toString());
        if (Path.WINDOWS) {
            TestPath.assertEquals((String)"c:/a/b", (String)new Path("c:\\a\\b").toString());
        }
    }

    public void testIsAbsolute() {
        TestPath.assertTrue((boolean)new Path("/").isAbsolute());
        TestPath.assertTrue((boolean)new Path("/foo").isAbsolute());
        TestPath.assertFalse((boolean)new Path("foo").isAbsolute());
        TestPath.assertFalse((boolean)new Path("foo/bar").isAbsolute());
        TestPath.assertFalse((boolean)new Path(".").isAbsolute());
        if (Path.WINDOWS) {
            TestPath.assertTrue((boolean)new Path("c:/a/b").isAbsolute());
            TestPath.assertFalse((boolean)new Path("c:a/b").isAbsolute());
        }
    }

    public void testParent() {
        TestPath.assertEquals((Object)new Path("/foo"), (Object)new Path("/foo/bar").getParent());
        TestPath.assertEquals((Object)new Path("foo"), (Object)new Path("foo/bar").getParent());
        TestPath.assertEquals((Object)new Path("/"), (Object)new Path("/foo").getParent());
        if (Path.WINDOWS) {
            TestPath.assertEquals((Object)new Path("c:/"), (Object)new Path("c:/foo").getParent());
        }
    }

    public void testChild() {
        TestPath.assertEquals((Object)new Path("."), (Object)new Path(".", "."));
        TestPath.assertEquals((Object)new Path("/"), (Object)new Path("/", "."));
        TestPath.assertEquals((Object)new Path("/"), (Object)new Path(".", "/"));
        TestPath.assertEquals((Object)new Path("/foo"), (Object)new Path("/", "foo"));
        TestPath.assertEquals((Object)new Path("/foo/bar"), (Object)new Path("/foo", "bar"));
        TestPath.assertEquals((Object)new Path("/foo/bar/baz"), (Object)new Path("/foo/bar", "baz"));
        TestPath.assertEquals((Object)new Path("/foo/bar/baz"), (Object)new Path("/foo", "bar/baz"));
        TestPath.assertEquals((Object)new Path("foo"), (Object)new Path(".", "foo"));
        TestPath.assertEquals((Object)new Path("foo/bar"), (Object)new Path("foo", "bar"));
        TestPath.assertEquals((Object)new Path("foo/bar/baz"), (Object)new Path("foo", "bar/baz"));
        TestPath.assertEquals((Object)new Path("foo/bar/baz"), (Object)new Path("foo/bar", "baz"));
        TestPath.assertEquals((Object)new Path("/foo"), (Object)new Path("/bar", "/foo"));
        if (Path.WINDOWS) {
            TestPath.assertEquals((Object)new Path("c:/foo"), (Object)new Path("/bar", "c:/foo"));
            TestPath.assertEquals((Object)new Path("c:/foo"), (Object)new Path("d:/bar", "c:/foo"));
        }
    }

    public void testEquals() {
        TestPath.assertFalse((boolean)new Path("/").equals((Object)new Path("/foo")));
    }

    public void testDots() {
        TestPath.assertEquals((String)new Path("/foo/bar/baz").toString(), (String)"/foo/bar/baz");
        TestPath.assertEquals((String)new Path("/foo/bar", ".").toString(), (String)"/foo/bar");
        TestPath.assertEquals((String)new Path("/foo/bar/../baz").toString(), (String)"/foo/baz");
        TestPath.assertEquals((String)new Path("/foo/bar/./baz").toString(), (String)"/foo/bar/baz");
        TestPath.assertEquals((String)new Path("/foo/bar/baz/../../fud").toString(), (String)"/foo/fud");
        TestPath.assertEquals((String)new Path("/foo/bar/baz/.././../fud").toString(), (String)"/foo/fud");
        TestPath.assertEquals((String)new Path("../../foo/bar").toString(), (String)"../../foo/bar");
        TestPath.assertEquals((String)new Path(".././../foo/bar").toString(), (String)"../../foo/bar");
        TestPath.assertEquals((String)new Path("./foo/bar/baz").toString(), (String)"foo/bar/baz");
        TestPath.assertEquals((String)new Path("/foo/bar/../../baz/boo").toString(), (String)"/baz/boo");
        TestPath.assertEquals((String)new Path("foo/bar/").toString(), (String)"foo/bar");
        TestPath.assertEquals((String)new Path("foo/bar/../baz").toString(), (String)"foo/baz");
        TestPath.assertEquals((String)new Path("foo/bar/../../baz/boo").toString(), (String)"baz/boo");
        TestPath.assertEquals((String)new Path("/foo/bar", "baz/boo").toString(), (String)"/foo/bar/baz/boo");
        TestPath.assertEquals((String)new Path("foo/bar/", "baz/bud").toString(), (String)"foo/bar/baz/bud");
        TestPath.assertEquals((String)new Path("/foo/bar", "../../boo/bud").toString(), (String)"/boo/bud");
        TestPath.assertEquals((String)new Path("foo/bar", "../../boo/bud").toString(), (String)"boo/bud");
        TestPath.assertEquals((String)new Path(".", "boo/bud").toString(), (String)"boo/bud");
        TestPath.assertEquals((String)new Path("/foo/bar/baz", "../../boo/bud").toString(), (String)"/foo/boo/bud");
        TestPath.assertEquals((String)new Path("foo/bar/baz", "../../boo/bud").toString(), (String)"foo/boo/bud");
        TestPath.assertEquals((String)new Path("../../", "../../boo/bud").toString(), (String)"../../../../boo/bud");
        TestPath.assertEquals((String)new Path("../../foo", "../../../boo/bud").toString(), (String)"../../../../boo/bud");
        TestPath.assertEquals((String)new Path("../../foo/bar", "../boo/bud").toString(), (String)"../../foo/boo/bud");
        TestPath.assertEquals((String)new Path("foo/bar/baz", "../../..").toString(), (String)"");
        TestPath.assertEquals((String)new Path("foo/bar/baz", "../../../../..").toString(), (String)"../..");
    }

    public void testScheme() throws IOException {
        TestPath.assertEquals((String)"foo:/bar", (String)new Path("foo:/", "/bar").toString());
        TestPath.assertEquals((String)"foo://bar/baz", (String)new Path("foo://bar/", "/baz").toString());
    }

    public void testURI() throws URISyntaxException, IOException {
        URI uri = new URI("file:///bar#baz");
        Path path = new Path(uri);
        TestPath.assertTrue((boolean)uri.equals(new URI(path.toString())));
        FileSystem fs = path.getFileSystem(new Configuration());
        TestPath.assertTrue((boolean)uri.equals(new URI(fs.makeQualified(path).toString())));
        URI uri2 = new URI("file:///bar/baz");
        TestPath.assertTrue((boolean)uri2.equals(new URI(fs.makeQualified(new Path(uri2)).toString())));
        TestPath.assertEquals((String)"foo://bar/baz#boo", (String)new Path("foo://bar/", new Path(new URI("/baz#boo"))).toString());
        TestPath.assertEquals((String)"foo://bar/baz/fud#boo", (String)new Path(new Path(new URI("foo://bar/baz#bud")), new Path(new URI("fud#boo"))).toString());
        TestPath.assertEquals((String)"foo://bar/fud#boo", (String)new Path(new Path(new URI("foo://bar/baz#bud")), new Path(new URI("/fud#boo"))).toString());
    }

    public void testGlobEscapeStatus() throws Exception {
        int i;
        LocalFileSystem lfs = FileSystem.getLocal((Configuration)new Configuration());
        Path testRoot = lfs.makeQualified(new Path(System.getProperty("test.build.data", "test/build/data"), "testPathGlob"));
        lfs.delete(testRoot, true);
        lfs.mkdirs(testRoot);
        TestPath.assertTrue((boolean)lfs.getFileStatus(testRoot).isDir());
        lfs.setWorkingDirectory(testRoot);
        Object[] paths = new Path[]{new Path(testRoot, "*/f"), new Path(testRoot, "d1/f"), new Path(testRoot, "d2/f")};
        Arrays.sort(paths);
        for (Object p : paths) {
            lfs.create((Path)p).close();
            TestPath.assertTrue((boolean)lfs.exists((Path)p));
        }
        Object[] stats = lfs.listStatus(new Path(testRoot, "*"));
        TestPath.assertEquals((int)1, (int)stats.length);
        TestPath.assertEquals((Object)new Path(testRoot, "*/f"), (Object)stats[0].getPath());
        stats = lfs.globStatus(new Path(testRoot, "*"));
        Arrays.sort(stats);
        TestPath.assertEquals((int)paths.length, (int)stats.length);
        for (i = 0; i < paths.length; ++i) {
            TestPath.assertEquals((Object)paths[i].getParent(), (Object)stats[i].getPath());
        }
        stats = lfs.globStatus(new Path(testRoot, "\\*"));
        TestPath.assertEquals((int)1, (int)stats.length);
        TestPath.assertEquals((Object)new Path(testRoot, "*"), (Object)stats[0].getPath());
        stats = lfs.globStatus(new Path(testRoot, "*/f"));
        TestPath.assertEquals((int)paths.length, (int)stats.length);
        for (i = 0; i < paths.length; ++i) {
            TestPath.assertEquals((Object)paths[i], (Object)stats[i].getPath());
        }
        stats = lfs.globStatus(new Path(testRoot, "\\*/f"));
        TestPath.assertEquals((int)1, (int)stats.length);
        TestPath.assertEquals((Object)new Path(testRoot, "*/f"), (Object)stats[0].getPath());
        stats = lfs.globStatus(new Path(testRoot, "\\*/*"));
        TestPath.assertEquals((int)1, (int)stats.length);
        TestPath.assertEquals((Object)new Path(testRoot, "*/f"), (Object)stats[0].getPath());
    }
}

