/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.Date;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.AccumulatingReducer;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.IOMapperBase;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.SequenceFileInputFormat;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.junit.Test;

public class TestDFSIO
extends Configured
implements Tool {
    private static final Log LOG = LogFactory.getLog(TestDFSIO.class);
    private static final int TEST_TYPE_READ = 0;
    private static final int TEST_TYPE_WRITE = 1;
    private static final int TEST_TYPE_CLEANUP = 2;
    private static final int DEFAULT_BUFFER_SIZE = 1000000;
    private static final String BASE_FILE_NAME = "test_io_";
    private static final String DEFAULT_RES_FILE_NAME = "TestDFSIO_results.log";
    private static final long MEGA = 0x100000L;
    private static String TEST_ROOT_DIR = System.getProperty("test.build.data", "/benchmarks/TestDFSIO");
    private static Path CONTROL_DIR = new Path(TEST_ROOT_DIR, "io_control");
    private static Path WRITE_DIR = new Path(TEST_ROOT_DIR, "io_write");
    private static Path READ_DIR = new Path(TEST_ROOT_DIR, "io_read");
    private static Path DATA_DIR = new Path(TEST_ROOT_DIR, "io_data");

    @Test
    public void testIOs() throws Exception {
        TestDFSIO.testIOs(10, 10, new Configuration());
    }

    public static void testIOs(int fileSize, int nrFiles, Configuration fsConfig) throws IOException {
        FileSystem fs = FileSystem.get((Configuration)fsConfig);
        TestDFSIO.createControlFile(fs, fileSize, nrFiles, fsConfig);
        TestDFSIO.writeTest(fs, fsConfig);
        TestDFSIO.readTest(fs, fsConfig);
        TestDFSIO.cleanup(fs);
    }

    private static void createControlFile(FileSystem fs, int fileSize, int nrFiles, Configuration fsConfig) throws IOException {
        LOG.info((Object)("creating control file: " + fileSize + " mega bytes, " + nrFiles + " files"));
        fs.delete(CONTROL_DIR, true);
        for (int i = 0; i < nrFiles; ++i) {
            String name = TestDFSIO.getFileName(i);
            Path controlFile = new Path(CONTROL_DIR, "in_file_" + name);
            SequenceFile.Writer writer = null;
            try {
                writer = SequenceFile.createWriter((FileSystem)fs, (Configuration)fsConfig, (Path)controlFile, Text.class, LongWritable.class, (SequenceFile.CompressionType)SequenceFile.CompressionType.NONE);
                writer.append((Writable)new Text(name), (Writable)new LongWritable((long)fileSize));
                continue;
            }
            catch (Exception e) {
                throw new IOException(e.getLocalizedMessage());
            }
            finally {
                if (writer != null) {
                    writer.close();
                }
                writer = null;
            }
        }
        LOG.info((Object)("created control files for: " + nrFiles + " files"));
    }

    private static String getFileName(int fIdx) {
        return BASE_FILE_NAME + Integer.toString(fIdx);
    }

    private static void writeTest(FileSystem fs, Configuration fsConfig) throws IOException {
        fs.delete(DATA_DIR, true);
        fs.delete(WRITE_DIR, true);
        TestDFSIO.runIOTest(WriteMapper.class, WRITE_DIR, fsConfig);
    }

    private static void runIOTest(Class<? extends Mapper<Text, LongWritable, Text, Text>> mapperClass, Path outputDir, Configuration fsConfig) throws IOException {
        JobConf job = new JobConf(fsConfig, TestDFSIO.class);
        FileInputFormat.setInputPaths((JobConf)job, (Path[])new Path[]{CONTROL_DIR});
        job.setInputFormat(SequenceFileInputFormat.class);
        job.setMapperClass(mapperClass);
        job.setReducerClass(AccumulatingReducer.class);
        FileOutputFormat.setOutputPath((JobConf)job, (Path)outputDir);
        job.setOutputKeyClass(Text.class);
        job.setOutputValueClass(Text.class);
        job.setNumReduceTasks(1);
        JobClient.runJob((JobConf)job);
    }

    private static void readTest(FileSystem fs, Configuration fsConfig) throws IOException {
        fs.delete(READ_DIR, true);
        TestDFSIO.runIOTest(ReadMapper.class, READ_DIR, fsConfig);
    }

    private static void sequentialTest(FileSystem fs, int testType, int fileSize, int nrFiles) throws Exception {
        IOStatMapper ioer = null;
        if (testType == 0) {
            ioer = new ReadMapper();
        } else if (testType == 1) {
            ioer = new WriteMapper();
        } else {
            return;
        }
        for (int i = 0; i < nrFiles; ++i) {
            ioer.doIO(Reporter.NULL, BASE_FILE_NAME + Integer.toString(i), 0x100000L * (long)fileSize);
        }
    }

    public static void main(String[] args) throws Exception {
        int res = ToolRunner.run((Tool)new TestDFSIO(), (String[])args);
        System.exit(res);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void analyzeResult(FileSystem fs, int testType, long execTime, String resFileName) throws IOException {
        Path reduceFile = testType == 1 ? new Path(WRITE_DIR, "part-00000") : new Path(READ_DIR, "part-00000");
        long tasks = 0L;
        long size = 0L;
        long time = 0L;
        float rate = 0.0f;
        float sqrate = 0.0f;
        FilterInputStream in = null;
        BufferedReader lines = null;
        try {
            String line;
            in = new DataInputStream((InputStream)fs.open(reduceFile));
            lines = new BufferedReader(new InputStreamReader(in));
            while ((line = lines.readLine()) != null) {
                StringTokenizer tokens = new StringTokenizer(line, " \t\n\r\f%");
                String attr = tokens.nextToken();
                if (attr.endsWith(":tasks")) {
                    tasks = Long.parseLong(tokens.nextToken());
                    continue;
                }
                if (attr.endsWith(":size")) {
                    size = Long.parseLong(tokens.nextToken());
                    continue;
                }
                if (attr.endsWith(":time")) {
                    time = Long.parseLong(tokens.nextToken());
                    continue;
                }
                if (attr.endsWith(":rate")) {
                    rate = Float.parseFloat(tokens.nextToken());
                    continue;
                }
                if (!attr.endsWith(":sqrate")) continue;
                sqrate = Float.parseFloat(tokens.nextToken());
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (lines != null) {
                lines.close();
            }
        }
        double med = rate / 1000.0f / (float)tasks;
        double stdDev = Math.sqrt(Math.abs((double)(sqrate / 1000.0f / (float)tasks) - med * med));
        String[] resultLines = new String[]{"----- TestDFSIO ----- : " + (testType == 1 ? "write" : (testType == 0 ? "read" : "unknown")), "           Date & time: " + new Date(System.currentTimeMillis()), "       Number of files: " + tasks, "Total MBytes processed: " + size / 0x100000L, "     Throughput mb/sec: " + (double)size * 1000.0 / (double)(time * 0x100000L), "Average IO rate mb/sec: " + med, " IO rate std deviation: " + stdDev, "    Test exec time sec: " + (float)execTime / 1000.0f, ""};
        PrintStream res = null;
        try {
            res = new PrintStream(new FileOutputStream(new File(resFileName), true));
            for (int i = 0; i < resultLines.length; ++i) {
                LOG.info((Object)resultLines[i]);
                res.println(resultLines[i]);
            }
        }
        finally {
            if (res != null) {
                res.close();
            }
        }
    }

    private static void cleanup(FileSystem fs) throws IOException {
        LOG.info((Object)"Cleaning up test files");
        fs.delete(new Path(TEST_ROOT_DIR), true);
    }

    public int run(String[] args) throws Exception {
        int testType = 0;
        int bufferSize = 1000000;
        int fileSize = 1;
        int nrFiles = 1;
        String resFileName = DEFAULT_RES_FILE_NAME;
        boolean isSequential = false;
        String className = TestDFSIO.class.getSimpleName();
        String version = className + ".0.0.4";
        String usage = "Usage: " + className + " -read | -write | -clean " + "[-nrFiles N] [-fileSize MB] [-resFile resultFileName] " + "[-bufferSize Bytes] ";
        System.out.println(version);
        if (args.length == 0) {
            System.err.println(usage);
            return -1;
        }
        for (int i = 0; i < args.length; ++i) {
            if (args[i].startsWith("-read")) {
                testType = 0;
                continue;
            }
            if (args[i].equals("-write")) {
                testType = 1;
                continue;
            }
            if (args[i].equals("-clean")) {
                testType = 2;
                continue;
            }
            if (args[i].startsWith("-seq")) {
                isSequential = true;
                continue;
            }
            if (args[i].equals("-nrFiles")) {
                nrFiles = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equals("-fileSize")) {
                fileSize = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equals("-bufferSize")) {
                bufferSize = Integer.parseInt(args[++i]);
                continue;
            }
            if (!args[i].equals("-resFile")) continue;
            resFileName = args[++i];
        }
        LOG.info((Object)("nrFiles = " + nrFiles));
        LOG.info((Object)("fileSize (MB) = " + fileSize));
        LOG.info((Object)("bufferSize = " + bufferSize));
        try {
            Configuration fsConfig = new Configuration(this.getConf());
            fsConfig.setInt("test.io.file.buffer.size", bufferSize);
            FileSystem fs = FileSystem.get((Configuration)fsConfig);
            if (isSequential) {
                long tStart = System.currentTimeMillis();
                TestDFSIO.sequentialTest(fs, testType, fileSize, nrFiles);
                long execTime = System.currentTimeMillis() - tStart;
                String resultLine = "Seq Test exec time sec: " + (float)execTime / 1000.0f;
                LOG.info((Object)resultLine);
                return 0;
            }
            if (testType == 2) {
                TestDFSIO.cleanup(fs);
                return 0;
            }
            TestDFSIO.createControlFile(fs, fileSize, nrFiles, fsConfig);
            long tStart = System.currentTimeMillis();
            if (testType == 1) {
                TestDFSIO.writeTest(fs, fsConfig);
            }
            if (testType == 0) {
                TestDFSIO.readTest(fs, fsConfig);
            }
            long execTime = System.currentTimeMillis() - tStart;
            TestDFSIO.analyzeResult(fs, testType, execTime, resFileName);
        }
        catch (Exception e) {
            System.err.print(StringUtils.stringifyException((Throwable)e));
            return -1;
        }
        return 0;
    }

    static {
        Configuration.addDefaultResource((String)"hdfs-default.xml");
        Configuration.addDefaultResource((String)"hdfs-site.xml");
    }

    public static class ReadMapper
    extends IOStatMapper<Long> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Long doIO(Reporter reporter, String name, long totalSize) throws IOException {
            totalSize *= 0x100000L;
            FSDataInputStream in = this.fs.open(new Path(DATA_DIR, name));
            long actualSize = 0L;
            try {
                while (actualSize < totalSize) {
                    int curSize = in.read(this.buffer, 0, this.bufferSize);
                    if (curSize < 0) {
                        break;
                    }
                    reporter.setStatus("reading " + name + "@" + (actualSize += (long)curSize) + "/" + totalSize + " ::host = " + this.hostName);
                }
            }
            finally {
                in.close();
            }
            return actualSize;
        }
    }

    public static class WriteMapper
    extends IOStatMapper<Long> {
        public WriteMapper() {
            for (int i = 0; i < this.bufferSize; ++i) {
                this.buffer[i] = (byte)(48 + i % 50);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Long doIO(Reporter reporter, String name, long totalSize) throws IOException {
            totalSize *= 0x100000L;
            FSDataOutputStream out = this.fs.create(new Path(DATA_DIR, name), true, this.bufferSize);
            try {
                for (long nrRemaining = totalSize; nrRemaining > 0L; nrRemaining -= (long)this.bufferSize) {
                    int curSize = (long)this.bufferSize < nrRemaining ? this.bufferSize : (int)nrRemaining;
                    out.write(this.buffer, 0, curSize);
                    reporter.setStatus("writing " + name + "@" + (totalSize - nrRemaining) + "/" + totalSize + " ::host = " + this.hostName);
                }
            }
            finally {
                out.close();
            }
            return totalSize;
        }
    }

    private static abstract class IOStatMapper<T>
    extends IOMapperBase<T> {
        IOStatMapper() {
        }

        @Override
        void collectStats(OutputCollector<Text, Text> output, String name, long execTime, Long objSize) throws IOException {
            long totalSize = objSize;
            float ioRateMbSec = (float)totalSize * 1000.0f / (float)(execTime * 0x100000L);
            LOG.info((Object)("Number of bytes processed = " + totalSize));
            LOG.info((Object)("Exec time = " + execTime));
            LOG.info((Object)("IO rate = " + ioRateMbSec));
            output.collect((Object)new Text("l:tasks"), (Object)new Text(String.valueOf(1)));
            output.collect((Object)new Text("l:size"), (Object)new Text(String.valueOf(totalSize)));
            output.collect((Object)new Text("l:time"), (Object)new Text(String.valueOf(execTime)));
            output.collect((Object)new Text("f:rate"), (Object)new Text(String.valueOf(ioRateMbSec * 1000.0f)));
            output.collect((Object)new Text("f:sqrate"), (Object)new Text(String.valueOf(ioRateMbSec * ioRateMbSec * 1000.0f)));
        }
    }
}

