/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools.rumen;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.apache.hadoop.mapred.JobPriority;
import org.apache.hadoop.mapreduce.JobACL;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.tools.rumen.HistoryEvent;
import org.apache.hadoop.tools.rumen.HistoryEventEmitter;
import org.apache.hadoop.tools.rumen.JobFinishedEvent;
import org.apache.hadoop.tools.rumen.JobInfoChangeEvent;
import org.apache.hadoop.tools.rumen.JobInitedEvent;
import org.apache.hadoop.tools.rumen.JobPriorityChangeEvent;
import org.apache.hadoop.tools.rumen.JobStatusChangedEvent;
import org.apache.hadoop.tools.rumen.JobSubmittedEvent;
import org.apache.hadoop.tools.rumen.JobUnsuccessfulCompletionEvent;
import org.apache.hadoop.tools.rumen.ParsedLine;
import org.apache.hadoop.tools.rumen.SingleEventEmitter;

public class Job20LineHistoryEventEmitter
extends HistoryEventEmitter {
    static List<SingleEventEmitter> nonFinals = new LinkedList<SingleEventEmitter>();
    static List<SingleEventEmitter> finals = new LinkedList<SingleEventEmitter>();
    Long originalSubmitTime = null;

    Job20LineHistoryEventEmitter() {
    }

    @Override
    List<SingleEventEmitter> finalSEEs() {
        return finals;
    }

    @Override
    List<SingleEventEmitter> nonFinalSEEs() {
        return nonFinals;
    }

    static {
        nonFinals.add(new JobSubmittedEventEmitter());
        nonFinals.add(new JobPriorityChangeEventEmitter());
        nonFinals.add(new JobStatusChangedEventEmitter());
        nonFinals.add(new JobInitedEventEmitter());
        nonFinals.add(new JobInfoChangeEventEmitter());
        finals.add(new JobUnsuccessfulCompletionEventEmitter());
        finals.add(new JobFinishedEventEmitter());
    }

    private static class JobFinishedEventEmitter
    extends SingleEventEmitter {
        private JobFinishedEventEmitter() {
        }

        @Override
        HistoryEvent maybeEmitEvent(ParsedLine line, String jobIDName, HistoryEventEmitter thatg) {
            if (jobIDName == null) {
                return null;
            }
            JobID jobID = JobID.forName((String)jobIDName);
            String finishTime = line.get("FINISH_TIME");
            String status = line.get("JOB_STATUS");
            String finishedMaps = line.get("FINISHED_MAPS");
            String finishedReduces = line.get("FINISHED_REDUCES");
            String failedMaps = line.get("FAILED_MAPS");
            String failedReduces = line.get("FAILED_REDUCES");
            String mapCounters = line.get("MAP_COUNTERS");
            String reduceCounters = line.get("REDUCE_COUNTERS");
            String counters = line.get("COUNTERS");
            if (status != null && status.equalsIgnoreCase("success") && finishTime != null && finishedMaps != null && finishedReduces != null) {
                return new JobFinishedEvent(jobID, Long.parseLong(finishTime), Integer.parseInt(finishedMaps), Integer.parseInt(finishedReduces), Integer.parseInt(failedMaps), Integer.parseInt(failedReduces), HistoryEventEmitter.maybeParseCounters(mapCounters), HistoryEventEmitter.maybeParseCounters(reduceCounters), HistoryEventEmitter.maybeParseCounters(counters));
            }
            return null;
        }
    }

    private static class JobUnsuccessfulCompletionEventEmitter
    extends SingleEventEmitter {
        private JobUnsuccessfulCompletionEventEmitter() {
        }

        @Override
        HistoryEvent maybeEmitEvent(ParsedLine line, String jobIDName, HistoryEventEmitter thatg) {
            if (jobIDName == null) {
                return null;
            }
            JobID jobID = JobID.forName((String)jobIDName);
            String finishTime = line.get("FINISH_TIME");
            String status = line.get("JOB_STATUS");
            String finishedMaps = line.get("FINISHED_MAPS");
            String finishedReduces = line.get("FINISHED_REDUCES");
            if (status != null && !status.equalsIgnoreCase("success") && finishTime != null && finishedMaps != null && finishedReduces != null) {
                return new JobUnsuccessfulCompletionEvent(jobID, Long.parseLong(finishTime), Integer.parseInt(finishedMaps), Integer.parseInt(finishedReduces), status);
            }
            return null;
        }
    }

    private static class JobInfoChangeEventEmitter
    extends SingleEventEmitter {
        private JobInfoChangeEventEmitter() {
        }

        @Override
        HistoryEvent maybeEmitEvent(ParsedLine line, String jobIDName, HistoryEventEmitter thatg) {
            if (jobIDName == null) {
                return null;
            }
            JobID jobID = JobID.forName((String)jobIDName);
            String launchTime = line.get("LAUNCH_TIME");
            if (launchTime != null) {
                Job20LineHistoryEventEmitter that = (Job20LineHistoryEventEmitter)thatg;
                return new JobInfoChangeEvent(jobID, that.originalSubmitTime, Long.parseLong(launchTime));
            }
            return null;
        }
    }

    private static class JobStatusChangedEventEmitter
    extends SingleEventEmitter {
        private JobStatusChangedEventEmitter() {
        }

        @Override
        HistoryEvent maybeEmitEvent(ParsedLine line, String jobIDName, HistoryEventEmitter thatg) {
            if (jobIDName == null) {
                return null;
            }
            JobID jobID = JobID.forName((String)jobIDName);
            String status = line.get("JOB_STATUS");
            if (status != null) {
                return new JobStatusChangedEvent(jobID, status);
            }
            return null;
        }
    }

    private static class JobInitedEventEmitter
    extends SingleEventEmitter {
        private JobInitedEventEmitter() {
        }

        @Override
        HistoryEvent maybeEmitEvent(ParsedLine line, String jobIDName, HistoryEventEmitter thatg) {
            if (jobIDName == null) {
                return null;
            }
            JobID jobID = JobID.forName((String)jobIDName);
            String launchTime = line.get("LAUNCH_TIME");
            String status = line.get("JOB_STATUS");
            String totalMaps = line.get("TOTAL_MAPS");
            String totalReduces = line.get("TOTAL_REDUCES");
            if (launchTime != null && totalMaps != null && totalReduces != null) {
                return new JobInitedEvent(jobID, Long.parseLong(launchTime), Integer.parseInt(totalMaps), Integer.parseInt(totalReduces), status);
            }
            return null;
        }
    }

    private static class JobPriorityChangeEventEmitter
    extends SingleEventEmitter {
        private JobPriorityChangeEventEmitter() {
        }

        @Override
        HistoryEvent maybeEmitEvent(ParsedLine line, String jobIDName, HistoryEventEmitter thatg) {
            JobID jobID = JobID.forName((String)jobIDName);
            if (jobIDName == null) {
                return null;
            }
            String priority = line.get("JOB_PRIORITY");
            if (priority != null) {
                return new JobPriorityChangeEvent(jobID, JobPriority.valueOf((String)priority));
            }
            return null;
        }
    }

    private static class JobSubmittedEventEmitter
    extends SingleEventEmitter {
        private JobSubmittedEventEmitter() {
        }

        @Override
        HistoryEvent maybeEmitEvent(ParsedLine line, String jobIDName, HistoryEventEmitter thatg) {
            String workflowTags;
            String workflowAdjacencies;
            String workflowNodeName;
            String workflowName;
            JobID jobID = JobID.forName((String)jobIDName);
            if (jobIDName == null) {
                return null;
            }
            String submitTime = line.get("SUBMIT_TIME");
            String jobConf = line.get("JOBCONF");
            String user = line.get("USER");
            String jobName = line.get("JOBNAME");
            String queueName = line.get("JOB_QUEUE");
            String workflowId = line.get("WORKFLOW_ID");
            if (workflowId == null) {
                workflowId = "";
            }
            if ((workflowName = line.get("WORKFLOW_NAME")) == null) {
                workflowName = "";
            }
            if ((workflowNodeName = line.get("WORKFLOW_NODE_NAME")) == null) {
                workflowNodeName = "";
            }
            if ((workflowAdjacencies = line.get("WORKFLOW_ADJACENCIES")) == null) {
                workflowAdjacencies = "";
            }
            if ((workflowTags = line.get("WORKFLOW_TAGS")) == null) {
                workflowTags = "";
            }
            if (submitTime != null) {
                Job20LineHistoryEventEmitter that = (Job20LineHistoryEventEmitter)thatg;
                that.originalSubmitTime = Long.parseLong(submitTime);
                HashMap<JobACL, AccessControlList> jobACLs = new HashMap<JobACL, AccessControlList>();
                return new JobSubmittedEvent(jobID, jobName, user == null ? "nulluser" : user, that.originalSubmitTime, jobConf, jobACLs, queueName, workflowId, workflowName, workflowNodeName, workflowAdjacencies, workflowTags);
            }
            return null;
        }
    }
}

