/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfsproxy;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.net.NetUtils;

public class LdapIpDirFilter
implements Filter {
    public static final Log LOG = LogFactory.getLog(LdapIpDirFilter.class);
    private static String baseName;
    private static String hdfsIpSchemaStr;
    private static String hdfsIpSchemaStrPrefix;
    private static String hdfsUidSchemaStr;
    private static String hdfsPathSchemaStr;
    private InitialLdapContext lctx;
    protected String contextPath;

    public void initialize(String bName, InitialLdapContext ctx) {
        baseName = bName;
        hdfsIpSchemaStr = "uniqueMember";
        hdfsIpSchemaStrPrefix = "cn=";
        hdfsUidSchemaStr = "uid";
        hdfsPathSchemaStr = "documentLocation";
        this.lctx = ctx;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        ServletContext context = filterConfig.getServletContext();
        this.contextPath = context.getContextPath();
        Configuration conf = new Configuration(false);
        conf.addResource("hdfsproxy-default.xml");
        conf.addResource("hdfsproxy-site.xml");
        String nn = this.getNamenode(conf);
        InetSocketAddress nAddr = NetUtils.createSocketAddr((String)nn);
        context.setAttribute("name.node.address", (Object)nAddr);
        context.setAttribute("name.conf", (Object)conf);
        context.setAttribute("current.conf", (Object)conf);
        context.setAttribute("org.apache.hadoop.hdfsproxy.conf", (Object)conf);
        if (this.lctx == null) {
            Hashtable<String, String> env = new Hashtable<String, String>();
            env.put("java.naming.factory.initial", conf.get("hdfsproxy.ldap.initial.context.factory", "com.sun.jndi.ldap.LdapCtxFactory"));
            env.put("java.naming.provider.url", conf.get("hdfsproxy.ldap.provider.url"));
            try {
                this.lctx = new InitialLdapContext(env, null);
            }
            catch (NamingException ne) {
                throw new ServletException("NamingException in initializing ldap" + ne.toString());
            }
            baseName = conf.get("hdfsproxy.ldap.role.base");
            hdfsIpSchemaStr = conf.get("hdfsproxy.ldap.ip.schema.string", "uniqueMember");
            hdfsIpSchemaStrPrefix = conf.get("hdfsproxy.ldap.ip.schema.string.prefix", "cn=");
            hdfsUidSchemaStr = conf.get("hdfsproxy.ldap.uid.schema.string", "uid");
            hdfsPathSchemaStr = conf.get("hdfsproxy.ldap.hdfs.path.schema.string", "documentLocation");
        }
        LOG.info((Object)(this.contextPath + ":: LdapIpDirFilter initialization successful"));
    }

    private String getNamenode(Configuration conf) throws ServletException {
        String nn = conf.get("fs.default.name");
        if (nn == null) {
            throw new ServletException("Proxy source cluster name node address not specified");
        }
        return nn;
    }

    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String prevThreadName = Thread.currentThread().getName();
        try {
            Thread.currentThread().setName(this.contextPath);
            HttpServletRequest rqst = (HttpServletRequest)request;
            HttpServletResponse rsp = (HttpServletResponse)response;
            if (LOG.isDebugEnabled()) {
                StringBuilder b = new StringBuilder("Request from ").append(rqst.getRemoteHost()).append("/").append(rqst.getRemoteAddr()).append(":").append(rqst.getRemotePort());
                b.append("\n The Scheme is " + rqst.getScheme());
                b.append("\n The Path Info is " + rqst.getPathInfo());
                b.append("\n The Translated Path Info is " + rqst.getPathTranslated());
                b.append("\n The Context Path is " + rqst.getContextPath());
                b.append("\n The Query String is " + rqst.getQueryString());
                b.append("\n The Request URI is " + rqst.getRequestURI());
                b.append("\n The Request URL is " + rqst.getRequestURL());
                b.append("\n The Servlet Path is " + rqst.getServletPath());
                LOG.debug((Object)b.toString());
            }
            LdapRoleEntry ldapent = new LdapRoleEntry();
            String userIp = rqst.getRemoteAddr();
            try {
                boolean isAuthorized = this.getLdapRoleEntryFromUserIp(userIp, ldapent);
                if (!isAuthorized) {
                    rsp.sendError(403, "IP " + userIp + " is not authorized to access");
                    return;
                }
            }
            catch (NamingException ne) {
                throw new IOException("NamingException while searching ldap" + ne.toString());
            }
            rqst.setAttribute("org.apache.hadoop.hdfsproxy.authorized.userID", (Object)ldapent.userId);
            rqst.setAttribute("org.apache.hadoop.hdfsproxy.authorized.paths", ldapent.paths);
            LOG.info((Object)("User: " + ldapent.userId + " Request: " + rqst.getPathInfo() + " From: " + rqst.getRemoteAddr()));
            chain.doFilter(request, response);
        }
        finally {
            Thread.currentThread().setName(prevThreadName);
        }
    }

    private boolean getLdapRoleEntryFromUserIp(String userIp, LdapRoleEntry ldapent) throws NamingException {
        String ipMember = hdfsIpSchemaStrPrefix + userIp;
        BasicAttributes matchAttrs = new BasicAttributes(true);
        matchAttrs.put(new BasicAttribute(hdfsIpSchemaStr, ipMember));
        matchAttrs.put(new BasicAttribute(hdfsUidSchemaStr));
        matchAttrs.put(new BasicAttribute(hdfsPathSchemaStr));
        String[] attrIDs = new String[]{hdfsUidSchemaStr, hdfsPathSchemaStr};
        NamingEnumeration<SearchResult> results = this.lctx.search(baseName, (Attributes)matchAttrs, attrIDs);
        if (results.hasMore()) {
            String userId = null;
            ArrayList<Path> paths = new ArrayList<Path>();
            SearchResult sr = results.next();
            Attributes attrs = sr.getAttributes();
            NamingEnumeration<? extends Attribute> ne = attrs.getAll();
            while (ne.hasMore()) {
                Attribute attr = ne.next();
                if (hdfsUidSchemaStr.equalsIgnoreCase(attr.getID())) {
                    userId = (String)attr.get();
                    continue;
                }
                if (!hdfsPathSchemaStr.equalsIgnoreCase(attr.getID())) continue;
                NamingEnumeration<?> e = attr.getAll();
                while (e.hasMore()) {
                    String pathStr = (String)e.next();
                    paths.add(new Path(pathStr));
                }
            }
            ldapent.init(userId, paths);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)ldapent);
            }
            return true;
        }
        LOG.info((Object)("Ip address " + userIp + " is not authorized to access the proxy server"));
        return false;
    }

    private class LdapRoleEntry {
        String userId;
        ArrayList<Path> paths;

        private LdapRoleEntry() {
        }

        void init(String userId, ArrayList<Path> paths) {
            this.userId = userId;
            this.paths = paths;
        }

        boolean contains(Path path) {
            return this.paths != null && this.paths.contains(path);
        }

        public String toString() {
            return "LdapRoleEntry{, userId='" + this.userId + '\'' + ", paths=" + this.paths + '}';
        }
    }
}

