/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfsproxy;

import java.io.IOException;
import java.util.Arrays;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfsproxy.AuthorizationFilter;
import org.apache.hadoop.security.UserGroupInformation;

public class KerberosAuthorizationFilter
extends AuthorizationFilter {
    private String defaultRealm;

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
        super.init(filterConfig);
        Configuration conf = new Configuration(false);
        conf.addResource("hdfsproxy-default.xml");
        conf.addResource("hdfsproxy-site.xml");
        this.initializeUGI(conf);
        this.initDefaultRealm(conf);
    }

    private void initializeUGI(Configuration conf) {
        try {
            conf.set("hadoop.security.authentication", "kerberos");
            UserGroupInformation.setConfiguration((Configuration)conf);
            UserGroupInformation.loginUserFromKeytab((String)conf.get("hdfsproxy.kerberos.principal"), (String)conf.get("hdfsproxy.kerberos.keytab"));
            LOG.info((Object)(this.contextPath + " :: Logged in user: " + UserGroupInformation.getLoginUser().getUserName() + ", Current User: " + UserGroupInformation.getCurrentUser().getUserName()));
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to initialize credentials", e);
        }
    }

    private void initDefaultRealm(Configuration conf) {
        this.defaultRealm = conf.get("hdfsproxy.kerberos.default.realm", "");
    }

    @Override
    protected String getUserId(ServletRequest request) {
        String userId = super.getUserId(request);
        return userId + (userId.indexOf(64) > 0 ? "" : this.defaultRealm);
    }

    @Override
    protected String getGroups(ServletRequest request) {
        UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)this.getUserId(request));
        return Arrays.toString(ugi.getGroupNames());
    }
}

