/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.contrib.failmon;

import java.util.ArrayList;
import org.apache.hadoop.contrib.failmon.Environment;
import org.apache.hadoop.contrib.failmon.LocalStore;
import org.apache.hadoop.contrib.failmon.MonitorJob;

public class RunOnce {
    LocalStore lstore;
    ArrayList<MonitorJob> monitors;
    boolean uploading = true;

    public RunOnce(String confFile) {
        Environment.prepare(confFile);
        String localTmpDir = System.getProperty("java.io.tmpdir");
        Environment.setProperty("local.tmp.dir", localTmpDir);
        this.monitors = Environment.getJobs();
        this.lstore = new LocalStore();
        this.uploading = true;
    }

    private void filter(String[] ftypes) {
        boolean found;
        ArrayList<MonitorJob> filtered = new ArrayList<MonitorJob>();
        for (MonitorJob job : this.monitors) {
            found = false;
            for (String ftype : ftypes) {
                if (!job.type.equalsIgnoreCase(ftype)) continue;
                found = true;
            }
            if (!found) continue;
            filtered.add(job);
        }
        found = false;
        for (String ftype : ftypes) {
            if (!ftype.equalsIgnoreCase("upload")) continue;
            found = true;
        }
        if (!found) {
            this.uploading = false;
        }
        this.monitors = filtered;
    }

    private void run() {
        Environment.logInfo("Failmon started successfully.");
        for (int i = 0; i < this.monitors.size(); ++i) {
            Environment.logInfo("Calling " + this.monitors.get((int)i).job.getInfo() + "...\t");
            this.monitors.get((int)i).job.monitor(this.lstore);
        }
        if (this.uploading) {
            this.lstore.upload();
        }
        this.lstore.close();
    }

    public void cleanup() {
    }

    public static void main(String[] args) {
        String configFilePath = "./conf/failmon.properties";
        String[] onlyList = null;
        for (int i = 0; i < args.length - 1; ++i) {
            if (args[i].equalsIgnoreCase("--config")) {
                configFilePath = args[i + 1];
                continue;
            }
            if (!args[i].equalsIgnoreCase("--only")) continue;
            onlyList = args[i + 1].split(",");
        }
        RunOnce ro = new RunOnce(configFilePath);
        if (onlyList != null) {
            ro.filter(onlyList);
        }
        ro.run();
    }
}

