/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.contrib.failmon;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Calendar;
import java.util.Properties;
import org.apache.hadoop.contrib.failmon.Environment;
import org.apache.hadoop.contrib.failmon.ParseState;

public class PersistentState {
    private static final String SEPARATOR = "###";
    static String filename;
    static Properties persData;

    public static void readState(String fname) {
        filename = fname;
        try {
            persData.load(new FileInputStream(filename));
        }
        catch (FileNotFoundException e1) {
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static ParseState getState(String fname) {
        long offset;
        String firstLine;
        String[] fields = persData.getProperty(fname, "null###0").split(SEPARATOR, 2);
        if (fields.length < 2) {
            System.err.println("Malformed persistent state data found");
            Environment.logInfo("Malformed persistent state data found");
            firstLine = null;
            offset = 0L;
        } else {
            firstLine = fields[0].equals("null") ? null : fields[0];
            offset = Long.parseLong(fields[1]);
        }
        return new ParseState(fname, firstLine, offset);
    }

    public static void setState(ParseState state) {
        if (state == null) {
            System.err.println("Null state found");
            Environment.logInfo("Null state found");
        }
        persData.setProperty(state.filename, state.firstLine + SEPARATOR + state.offset);
    }

    public static void updateState(String filename, String firstLine, long offset) {
        ParseState ps = PersistentState.getState(filename);
        if (firstLine != null) {
            ps.firstLine = firstLine;
        }
        ps.offset = offset;
        PersistentState.setState(ps);
    }

    public static void writeState(String fname) {
        try {
            persData.store(new FileOutputStream(fname), Calendar.getInstance().getTime().toString());
        }
        catch (FileNotFoundException e1) {
            e1.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static {
        persData = new Properties();
    }
}

