/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.contrib.failmon;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.zip.CRC32;
import java.util.zip.CheckedOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.contrib.failmon.Anonymizer;
import org.apache.hadoop.contrib.failmon.Environment;
import org.apache.hadoop.contrib.failmon.EventRecord;
import org.apache.hadoop.contrib.failmon.SerializedRecord;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class LocalStore {
    public static final char FIELD_SEPARATOR = '|';
    public static final char RECORD_SEPARATOR = '\n';
    public static final String COMPRESSION_SUFFIX = ".zip";
    public static final int UPLOAD_INTERVAL = 600;
    String filename;
    String hdfsDir;
    boolean compress;
    FileWriter fw;
    BufferedWriter writer;

    public LocalStore() {
        if (Environment.getProperty("local.tmp.filename") == null) {
            Environment.setProperty("local.tmp.filename", "failmon.dat");
        }
        if (Environment.getProperty("local.tmp.dir") == null) {
            Environment.setProperty("local.tmp.dir", System.getProperty("java.io.tmpdir"));
        }
        this.filename = Environment.getProperty("local.tmp.dir") + "/" + Environment.getProperty("local.tmp.filename");
        this.hdfsDir = Environment.getProperty("hdfs.upload.dir");
        if (this.hdfsDir == null) {
            this.hdfsDir = "/failmon";
        }
        this.compress = true;
        if ("false".equalsIgnoreCase(Environment.getProperty("local.tmp.compression"))) {
            this.compress = false;
        }
        try {
            this.fw = new FileWriter(this.filename, true);
            this.writer = new BufferedWriter(this.fw);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void insert(EventRecord er) {
        SerializedRecord sr = new SerializedRecord(er);
        try {
            Anonymizer.anonymize(sr);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.append(sr);
    }

    public void insert(EventRecord[] ers) {
        for (EventRecord er : ers) {
            this.insert(er);
        }
    }

    private void append(SerializedRecord sr) {
        try {
            this.writer.write(LocalStore.pack(sr).toString());
            this.writer.write(10);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static StringBuffer pack(SerializedRecord sr) {
        StringBuffer sb = new StringBuffer();
        ArrayList<String> keys = new ArrayList<String>(sr.fields.keySet());
        if (sr.isValid()) {
            SerializedRecord.arrangeKeys(keys);
        }
        for (int i = 0; i < keys.size(); ++i) {
            String value = sr.fields.get(keys.get(i));
            sb.append(keys.get(i) + ":" + value);
            sb.append('|');
        }
        return sb;
    }

    public void upload() {
        try {
            this.writer.flush();
            if (this.compress) {
                LocalStore.zipCompress(this.filename);
            }
            String remoteName = "failmon-";
            remoteName = "true".equalsIgnoreCase(Environment.getProperty("anonymizer.hash.hostnames")) ? remoteName + Anonymizer.getMD5Hash(InetAddress.getLocalHost().getCanonicalHostName()) + "-" : remoteName + InetAddress.getLocalHost().getCanonicalHostName() + "-";
            remoteName = remoteName + Calendar.getInstance().getTimeInMillis();
            if (this.compress) {
                LocalStore.copyToHDFS(this.filename + COMPRESSION_SUFFIX, this.hdfsDir + "/" + remoteName + COMPRESSION_SUFFIX);
            } else {
                LocalStore.copyToHDFS(this.filename, this.hdfsDir + "/" + remoteName);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            this.fw.close();
            this.fw = new FileWriter(this.filename);
            this.writer = new BufferedWriter(this.fw);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void zipCompress(String filename) throws IOException {
        int c;
        FileOutputStream fos = new FileOutputStream(filename + COMPRESSION_SUFFIX);
        CheckedOutputStream csum = new CheckedOutputStream(fos, new CRC32());
        ZipOutputStream out = new ZipOutputStream(new BufferedOutputStream(csum));
        out.setComment("Failmon records.");
        BufferedReader in = new BufferedReader(new FileReader(filename));
        out.putNextEntry(new ZipEntry(new File(filename).getName()));
        while ((c = in.read()) != -1) {
            out.write(c);
        }
        in.close();
        out.finish();
        out.close();
    }

    public static void copyToHDFS(String localFile, String hdfsFile) throws IOException {
        String hadoopConfPath = Environment.getProperty("hadoop.conf.path") == null ? "../../../conf" : Environment.getProperty("hadoop.conf.path");
        Configuration hadoopConf = new Configuration();
        hadoopConf.addResource(new Path(hadoopConfPath + "/hadoop-default.xml"));
        hadoopConf.addResource(new Path(hadoopConfPath + "/hadoop-site.xml"));
        FileSystem fs = FileSystem.get((Configuration)hadoopConf);
        Path inFile = new Path("file://" + localFile);
        Path outFile = new Path(hadoopConf.get("fs.default.name") + hdfsFile);
        Environment.logInfo("Uploading to HDFS (file " + outFile + ") ...");
        fs.copyFromLocalFile(false, inFile, outFile);
    }

    public void close() {
        try {
            this.writer.flush();
            this.writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

