/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.contrib.failmon;

import java.io.IOException;
import java.util.Calendar;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.contrib.failmon.Environment;
import org.apache.hadoop.contrib.failmon.EventRecord;
import org.apache.hadoop.contrib.failmon.LogParser;

public class HadoopLogParser
extends LogParser {
    public HadoopLogParser(String fname) {
        super(fname);
        this.dateformat = Environment.getProperty("log.hadoop.dateformat");
        if (this.dateformat == null) {
            this.dateformat = "\\d{4}-\\d{2}-\\d{2}";
        }
        if ((this.timeformat = Environment.getProperty("log.hadoop.timeformat")) == null) {
            this.timeformat = "\\d{2}:\\d{2}:\\d{2}";
        }
        this.findHostname();
    }

    @Override
    public EventRecord parseLine(String line) throws IOException {
        EventRecord retval = null;
        if (line != null) {
            String patternStr = "(" + this.dateformat + ")";
            patternStr = patternStr + "\\s+";
            patternStr = patternStr + "(" + this.timeformat + ")";
            patternStr = patternStr + ".{4}\\s(\\w*)\\s";
            patternStr = patternStr + "\\s*([\\w+\\.?]+)";
            Pattern pattern = Pattern.compile(patternStr = patternStr + ":\\s+(.+)");
            Matcher matcher = pattern.matcher(line);
            retval = matcher.find(0) && matcher.groupCount() >= 5 ? new EventRecord(this.hostname, this.ips, this.parseDate(matcher.group(1), matcher.group(2)), "HadoopLog", matcher.group(3), matcher.group(4), matcher.group(5)) : new EventRecord();
        }
        return retval;
    }

    @Override
    protected Calendar parseDate(String strDate, String strTime) {
        Calendar retval = Calendar.getInstance();
        String[] fields = strDate.split("-");
        retval.set(1, Integer.parseInt(fields[0]));
        retval.set(2, Integer.parseInt(fields[1]));
        retval.set(5, Integer.parseInt(fields[2]));
        fields = strTime.split(":");
        retval.set(11, Integer.parseInt(fields[0]));
        retval.set(12, Integer.parseInt(fields[1]));
        retval.set(13, Integer.parseInt(fields[2]));
        return retval;
    }

    private void findHostname() {
        String startupInfo = Environment.runCommand("grep --max-count=1 STARTUP_MSG:\\s*host " + this.file.getName()).toString();
        Pattern pattern = Pattern.compile("\\s+(\\w+/.+)\\s+");
        Matcher matcher = pattern.matcher(startupInfo);
        if (matcher.find(0)) {
            this.hostname = matcher.group(1).split("/")[0];
            this.ips = new String[1];
            this.ips[0] = matcher.group(1).split("/")[1];
        }
    }

    @Override
    public String getInfo() {
        return "Hadoop Log Parser for file: " + this.file.getName();
    }
}

