/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.contrib.failmon;

import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.Calendar;
import java.util.zip.ZipInputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.contrib.failmon.Environment;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class HDFSMerger {
    Configuration hadoopConf;
    FileSystem hdfs;
    String hdfsDir;
    FileStatus[] inputFiles;
    Path outputFilePath;
    FSDataOutputStream outputFile;
    boolean compress;
    FileWriter fw;
    BufferedWriter writer;

    public HDFSMerger() throws IOException {
        String hadoopConfPath = Environment.getProperty("hadoop.conf.path") == null ? "../../../conf" : Environment.getProperty("hadoop.conf.path");
        Configuration hadoopConf = new Configuration();
        hadoopConf.addResource(new Path(hadoopConfPath + "/hadoop-default.xml"));
        hadoopConf.addResource(new Path(hadoopConfPath + "/hadoop-site.xml"));
        if (Environment.getProperty("local.tmp.filename") == null) {
            Environment.setProperty("local.tmp.filename", "failmon.dat");
        }
        this.hdfsDir = Environment.getProperty("hdfs.upload.dir");
        if (this.hdfsDir == null) {
            this.hdfsDir = "/failmon";
        }
        this.hdfs = FileSystem.get((Configuration)hadoopConf);
        Path hdfsDirPath = new Path(hadoopConf.get("fs.default.name") + this.hdfsDir);
        try {
            if (!this.hdfs.getFileStatus(hdfsDirPath).isDir()) {
                Environment.logInfo("HDFSMerger: Not an HDFS directory: " + hdfsDirPath.toString());
                System.exit(0);
            }
        }
        catch (FileNotFoundException e) {
            Environment.logInfo("HDFSMerger: Directory not found: " + hdfsDirPath.toString());
        }
        this.inputFiles = this.hdfs.listStatus(hdfsDirPath);
        this.outputFilePath = new Path(hdfsDirPath.toString() + "/" + "merge-" + Calendar.getInstance().getTimeInMillis() + ".dat");
        this.outputFile = this.hdfs.create(this.outputFilePath);
        for (FileStatus fstatus : this.inputFiles) {
            this.appendFile(fstatus.getPath());
            this.hdfs.delete(fstatus.getPath());
        }
        this.outputFile.close();
        Environment.logInfo("HDFS file merging complete!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void appendFile(Path inputPath) throws IOException {
        Object inputFile;
        FSDataInputStream anyInputFile = this.hdfs.open(inputPath);
        byte[] buffer = new byte[4096];
        if (inputPath.toString().endsWith(".zip")) {
            inputFile = new ZipInputStream((InputStream)anyInputFile);
            ((ZipInputStream)inputFile).getNextEntry();
        } else {
            inputFile = anyInputFile;
        }
        try {
            int bytesRead = 0;
            while ((bytesRead = ((InputStream)inputFile).read(buffer)) > 0) {
                this.outputFile.write(buffer, 0, bytesRead);
            }
        }
        catch (IOException e) {
            Environment.logInfo("Error while copying file:" + inputPath.toString());
        }
        finally {
            ((InputStream)inputFile).close();
        }
    }

    public static void main(String[] args) {
        Environment.prepare("./conf/failmon.properties");
        try {
            new HDFSMerger();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

