/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.contrib.failmon;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;

public class EventRecord {
    HashMap<String, Object> fields = new HashMap();

    public EventRecord(String _hostname, Object[] _ips, Calendar _timestamp, String _type, String _logLevel, String _source, String _message) {
        this.fields.clear();
        this.set("hostname", _hostname);
        this.set("ips", _ips);
        this.set("timestamp", _timestamp);
        this.set("type", _type);
        this.set("logLevel", _logLevel);
        this.set("source", _source);
        this.set("message", _message);
    }

    public EventRecord() {
        this.fields.clear();
        this.set("hostname", "invalid");
    }

    public final HashMap<String, Object> getMap() {
        return this.fields;
    }

    public void set(String fieldName, Object fieldValue) {
        if (fieldValue != null) {
            this.fields.put(fieldName, fieldValue);
        }
    }

    public Object get(String fieldName) {
        return this.fields.get(fieldName);
    }

    public boolean isValid() {
        return !"invalid".equalsIgnoreCase((String)this.fields.get("hostname"));
    }

    public String toString() {
        String retval = "";
        ArrayList<String> keys = new ArrayList<String>(this.fields.keySet());
        Collections.sort(keys);
        for (int i = 0; i < keys.size(); ++i) {
            Object value = this.fields.get(keys.get(i));
            if (value == null) {
                retval = retval + keys.get(i) + ":\tnull\n";
                continue;
            }
            if (value instanceof String) {
                retval = retval + keys.get(i) + ":\t" + value + "\n";
                continue;
            }
            if (value instanceof Calendar) {
                retval = retval + keys.get(i) + ":\t" + ((Calendar)value).getTime() + "\n";
                continue;
            }
            if (value instanceof InetAddress[] || value instanceof String[]) {
                retval = retval + "Known IPs:\t";
                for (InetAddress ip : (InetAddress[])value) {
                    retval = retval + ip.getHostAddress() + " ";
                }
                retval = retval + "\n";
                continue;
            }
            retval = retval + keys.get(i) + ":\t" + value.toString() + "\n";
        }
        return retval;
    }
}

