/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.contrib.failmon;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.contrib.failmon.CPUParser;
import org.apache.hadoop.contrib.failmon.HadoopLogParser;
import org.apache.hadoop.contrib.failmon.MonitorJob;
import org.apache.hadoop.contrib.failmon.NICParser;
import org.apache.hadoop.contrib.failmon.PersistentState;
import org.apache.hadoop.contrib.failmon.SMARTParser;
import org.apache.hadoop.contrib.failmon.SensorsParser;
import org.apache.hadoop.contrib.failmon.SystemLogParser;
import org.apache.log4j.PropertyConfigurator;

public class Environment {
    public static final int DEFAULT_LOG_INTERVAL = 3600;
    public static final int DEFAULT_POLL_INTERVAL = 360;
    public static int MIN_INTERVAL = 5;
    public static final int MAX_OUTPUT_LENGTH = 51200;
    public static Log LOG;
    static Properties fmProperties;
    static boolean superuser;
    static boolean ready;

    public static void prepare(String fname) {
        if (!"Linux".equalsIgnoreCase(System.getProperty("os.name"))) {
            System.err.println("Linux system required for FailMon. Exiting...");
            System.exit(0);
        }
        System.setProperty("log4j.configuration", "conf/log4j.properties");
        PropertyConfigurator.configure((String)"conf/log4j.properties");
        LOG = LogFactory.getLog((String)"org.apache.hadoop.contrib.failmon");
        Environment.logInfo("********** FailMon started ***********");
        PersistentState.readState("conf/parsing.state");
        try {
            FileInputStream propFile = new FileInputStream(fname);
            fmProperties.load(propFile);
            propFile.close();
        }
        catch (FileNotFoundException e1) {
            e1.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        ready = true;
        try {
            String sudo_prompt = "passwd_needed:";
            String echo_txt = "access_ok";
            Process p = Runtime.getRuntime().exec("sudo -S -p " + sudo_prompt + " echo " + echo_txt);
            InputStream inps = p.getInputStream();
            InputStream errs = p.getErrorStream();
            while (inps.available() < echo_txt.length() && errs.available() < sudo_prompt.length()) {
                Thread.sleep(100L);
            }
            if (inps.available() >= echo_txt.length()) {
                byte[] buf = new byte[inps.available()];
                inps.read(buf);
                String s = new String(buf);
                if (s.startsWith(echo_txt)) {
                    superuser = true;
                    Environment.logInfo("Superuser privileges found!");
                } else {
                    superuser = false;
                    Environment.logInfo("Superuser privileges not found.");
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public static String getProperty(String key) {
        if (!ready) {
            Environment.prepare("conf/failmon.properties");
        }
        return fmProperties.getProperty(key);
    }

    public static void setProperty(String key, String value) {
        fmProperties.setProperty(key, value);
    }

    public static ArrayList<MonitorJob> getJobs() {
        File f;
        ArrayList<MonitorJob> monitors = new ArrayList<MonitorJob>();
        int timeInt = 0;
        String[] fnames_r = Environment.getProperty("log.hadoop.filenames").split(",\\s*");
        String tmp = Environment.getProperty("log.hadoop.enabled");
        String[] fnames = Environment.expandDirs(fnames_r, ".*(.log).*");
        timeInt = Environment.setValue("log.hadoop.interval", 3600);
        if ("true".equalsIgnoreCase(tmp) && fnames[0] != null) {
            for (String fname : fnames) {
                f = new File(fname);
                if (f.exists() && f.canRead()) {
                    monitors.add(new MonitorJob(new HadoopLogParser(fname), "hadoopLog", timeInt));
                    Environment.logInfo("Created Monitor for Hadoop log file: " + f.getAbsolutePath());
                    continue;
                }
                if (!f.exists()) {
                    Environment.logInfo("Skipping Hadoop log file " + fname + " (file not found)");
                    continue;
                }
                Environment.logInfo("Skipping Hadoop log file " + fname + " (permission denied)");
            }
        }
        fnames_r = Environment.getProperty("log.system.filenames").split(",\\s*");
        tmp = Environment.getProperty("log.system.enabled");
        fnames = Environment.expandDirs(fnames_r, ".*(messages).*");
        timeInt = Environment.setValue("log.system.interval", 3600);
        if ("true".equalsIgnoreCase(tmp)) {
            for (String fname : fnames) {
                f = new File(fname);
                if (f.exists() && f.canRead()) {
                    monitors.add(new MonitorJob(new SystemLogParser(fname), "systemLog", timeInt));
                    Environment.logInfo("Created Monitor for System log file: " + f.getAbsolutePath());
                    continue;
                }
                if (!f.exists()) {
                    Environment.logInfo("Skipping system log file " + fname + " (file not found)");
                    continue;
                }
                Environment.logInfo("Skipping system log file " + fname + " (permission denied)");
            }
        }
        tmp = Environment.getProperty("nic.enabled");
        timeInt = Environment.setValue("nics.interval", 360);
        if ("true".equalsIgnoreCase(tmp)) {
            monitors.add(new MonitorJob(new NICParser(), "nics", timeInt));
            Environment.logInfo("Created Monitor for NICs");
        }
        tmp = Environment.getProperty("cpu.enabled");
        timeInt = Environment.setValue("cpu.interval", 360);
        if ("true".equalsIgnoreCase(tmp)) {
            monitors.add(new MonitorJob(new CPUParser(), "cpu", timeInt));
            Environment.logInfo("Created Monitor for CPUs");
        }
        tmp = Environment.getProperty("disks.enabled");
        timeInt = Environment.setValue("disks.interval", 360);
        if ("true".equalsIgnoreCase(tmp)) {
            boolean smart_present = Environment.checkExistence("smartctl");
            int disks_ok = 0;
            String devicesStr = Environment.getProperty("disks.list");
            String[] devices = null;
            if (devicesStr != null) {
                devices = devicesStr.split(",\\s*");
            }
            for (int i = 0; i < devices.length; ++i) {
                boolean file_present = false;
                boolean disk_present = false;
                String fileloc = Environment.getProperty("disks." + devices[i] + ".source");
                if (fileloc != null && fileloc.equalsIgnoreCase("true")) {
                    file_present = true;
                }
                if (!file_present && superuser) {
                    StringBuffer sb = Environment.runCommand("sudo smartctl -i " + devices[i]);
                    String patternStr = "[(failed)(device not supported)]";
                    Pattern pattern = Pattern.compile(patternStr);
                    Matcher matcher = pattern.matcher(sb.toString());
                    disk_present = !matcher.find(0);
                }
                if (file_present || disk_present && smart_present) {
                    ++disks_ok;
                    continue;
                }
                devices[i] = null;
            }
            StringBuffer resetSB = new StringBuffer();
            for (int j = 0; j < devices.length; ++j) {
                resetSB.append(devices[j] == null ? "" : devices[j] + ", ");
                if (devices[j] == null) continue;
                Environment.logInfo("Found S.M.A.R.T. attributes for disk " + devices[j]);
            }
            if (resetSB.length() >= 2) {
                Environment.setProperty("disks.list", resetSB.substring(0, resetSB.length() - 2));
            }
            if (disks_ok > 0) {
                monitors.add(new MonitorJob(new SMARTParser(), "disks", timeInt));
                Environment.logInfo("Created Monitor for S.M.A.R.T disk attributes");
            }
        }
        tmp = Environment.getProperty("sensors.enabled");
        timeInt = Environment.setValue("sensors.interval", 360);
        if ("true".equalsIgnoreCase(tmp) && Environment.checkExistence("sensors")) {
            monitors.add(new MonitorJob(new SensorsParser(), "sensors", timeInt));
            Environment.logInfo("Created Monitor for lm-sensors output");
        }
        return monitors;
    }

    public static int getInterval(ArrayList<MonitorJob> monitors) {
        String tmp = Environment.getProperty("executor.interval.min");
        if (tmp != null) {
            MIN_INTERVAL = Integer.parseInt(tmp);
        }
        int[] monIntervals = new int[monitors.size()];
        for (int i = 0; i < monitors.size(); ++i) {
            monIntervals[i] = monitors.get((int)i).interval;
        }
        return Math.max(MIN_INTERVAL, Environment.gcd(monIntervals));
    }

    public static boolean checkExistence(String cmd) {
        StringBuffer sb = Environment.runCommand("which " + cmd);
        return sb.length() > 1;
    }

    public static StringBuffer runCommand(String[] cmd) {
        StringBuffer retval = new StringBuffer(51200);
        try {
            int c;
            Process p = Runtime.getRuntime().exec(cmd);
            InputStream tmp = p.getInputStream();
            p.waitFor();
            while ((c = tmp.read()) != -1) {
                retval.append((char)c);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return retval;
    }

    public static StringBuffer runCommand(String cmd) {
        return Environment.runCommand(cmd.split("\\s+"));
    }

    public static int gcd(int m, int n) {
        int r;
        if (m == 0 && n == 0) {
            return 0;
        }
        if (m < n) {
            int t = m;
            m = n;
            n = t;
        }
        if ((r = m % n) == 0) {
            return n;
        }
        return Environment.gcd(n, r);
    }

    public static int gcd(int[] numbers) {
        if (numbers.length == 1) {
            return numbers[0];
        }
        int g = Environment.gcd(numbers[0], numbers[1]);
        for (int i = 2; i < numbers.length; ++i) {
            g = Environment.gcd(g, numbers[i]);
        }
        return g;
    }

    private static String[] expandDirs(String[] input, String patternStr) {
        ArrayList<String> fnames = new ArrayList<String>();
        Pattern pattern = Pattern.compile(patternStr);
        for (String fname : input) {
            File f = new File(fname);
            if (!f.exists()) continue;
            if (f.isDirectory()) {
                File[] fcs;
                for (File fc : fcs = f.listFiles()) {
                    Matcher matcher = pattern.matcher(fc.getName());
                    if (!matcher.find() || !fc.isFile()) continue;
                    fnames.add(fc.getAbsolutePath());
                }
                continue;
            }
            fnames.add(f.getAbsolutePath());
        }
        return fnames.toArray(input);
    }

    private static int setValue(String propname, int defaultValue) {
        String v = Environment.getProperty(propname);
        if (v != null) {
            return Integer.parseInt(v);
        }
        return defaultValue;
    }

    public static void logInfo(String str) {
        LOG.info((Object)str);
    }

    static {
        fmProperties = new Properties();
        superuser = false;
        ready = false;
    }
}

