/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.contrib.failmon;

import java.net.InetAddress;
import java.util.Calendar;
import org.apache.hadoop.contrib.failmon.Environment;
import org.apache.hadoop.contrib.failmon.EventRecord;
import org.apache.hadoop.contrib.failmon.ShellParser;

public class CPUParser
extends ShellParser {
    @Override
    public EventRecord query(String s) throws Exception {
        StringBuffer sb = Environment.runCommand("cat /proc/cpuinfo");
        EventRecord retval = new EventRecord(InetAddress.getLocalHost().getCanonicalHostName(), InetAddress.getAllByName(InetAddress.getLocalHost().getHostName()), Calendar.getInstance(), "CPU", "Unknown", "CPU", "-");
        retval.set("processors", this.findAll("\\s*processor\\s*:\\s*(\\d+)", sb.toString(), 1, ", "));
        retval.set("model name", this.findPattern("\\s*model name\\s*:\\s*(.+)", sb.toString(), 1));
        retval.set("frequency", this.findAll("\\s*cpu\\s*MHz\\s*:\\s*(\\d+)", sb.toString(), 1, ", "));
        retval.set("physical id", this.findAll("\\s*physical\\s*id\\s*:\\s*(\\d+)", sb.toString(), 1, ", "));
        retval.set("core id", this.findAll("\\s*core\\s*id\\s*:\\s*(\\d+)", sb.toString(), 1, ", "));
        return retval;
    }

    @Override
    public EventRecord[] monitor() {
        EventRecord[] recs = new EventRecord[1];
        try {
            recs[0] = this.query(null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return recs;
    }

    @Override
    public String getInfo() {
        return "CPU Info parser";
    }
}

