/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.vaidya.postexdiagnosis.tests;

import org.apache.hadoop.vaidya.DiagnosticTest;
import org.apache.hadoop.vaidya.statistics.job.JobStatistics;
import org.apache.hadoop.vaidya.statistics.job.JobStatisticsInterface;

public class ReducesReExecutionImpact
extends DiagnosticTest {
    private double _impact;
    private JobStatistics _job;
    private long _percentReducesReExecuted;

    @Override
    public double evaluate(JobStatistics job) {
        this._job = job;
        if (job.getStringValue(JobStatisticsInterface.JobKeys.JOBTYPE).equals("MAP_ONLY")) {
            this._impact = 0.0;
            return this._impact;
        }
        this._impact = (job.getLongValue(JobStatisticsInterface.JobKeys.LAUNCHED_REDUCES) - job.getLongValue(JobStatisticsInterface.JobKeys.TOTAL_REDUCES)) / job.getLongValue(JobStatisticsInterface.JobKeys.TOTAL_REDUCES);
        this._percentReducesReExecuted = Math.round(this._impact * 100.0);
        return this._impact;
    }

    @Override
    public String getPrescription() {
        return "* Need careful evaluation of why reduce tasks are re-executed. \n  * It could be due to some set of unstable cluster nodes.\n  * It could be due application specific failures.";
    }

    @Override
    public String getReferenceDetails() {
        String ref = "* Total Reduce Tasks: " + this._job.getLongValue(JobStatisticsInterface.JobKeys.TOTAL_REDUCES) + "\n" + "* Launched Reduce Tasks: " + this._job.getLongValue(JobStatisticsInterface.JobKeys.LAUNCHED_REDUCES) + "\n" + "* Percent Reduce Tasks ReExecuted: " + this._percentReducesReExecuted + "\n" + "* Impact: " + ReducesReExecutionImpact.truncate(this._impact);
        return ref;
    }
}

