/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.vaidya.postexdiagnosis;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.mapred.DefaultJobHistoryParser;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobHistory;
import org.apache.hadoop.vaidya.DiagnosticTest;
import org.apache.hadoop.vaidya.JobDiagnoser;
import org.apache.hadoop.vaidya.statistics.job.JobStatistics;
import org.apache.hadoop.vaidya.util.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class PostExPerformanceDiagnoser
extends JobDiagnoser {
    private String _jobHistoryFile = null;
    private InputStream _testsConfFileIs = null;
    private String _reportFile = null;
    private String _jobConfFile = null;
    private JobStatistics _jobExecutionStatistics;

    public String getReportFile() {
        return this._reportFile;
    }

    public String getJobHistoryFile() {
        return this._jobHistoryFile;
    }

    public InputStream getTestsConfFileIs() {
        return this._testsConfFileIs;
    }

    public void setTestsConfFileIs(InputStream testsConfFileIs) {
        this._testsConfFileIs = testsConfFileIs;
    }

    public JobStatistics getJobExecutionStatistics() {
        return this._jobExecutionStatistics;
    }

    public PostExPerformanceDiagnoser(String jobConfFile, String jobHistoryFile, InputStream testsConfFileIs, String reportFile) throws Exception {
        this._jobHistoryFile = jobHistoryFile;
        this._testsConfFileIs = testsConfFileIs;
        this._reportFile = reportFile;
        this._jobConfFile = jobConfFile;
        JobConf jobConf = new JobConf();
        JobHistory.JobInfo jobInfo = new JobHistory.JobInfo("");
        this.readJobInformation(jobConf, jobInfo);
        this._jobExecutionStatistics = new JobStatistics(jobConf, jobInfo);
    }

    private void readJobInformation(JobConf jobConf, JobHistory.JobInfo jobInfo) throws Exception {
        URL jobConfFileUrl = new URL(this._jobConfFile);
        URL jobHistoryFileUrl = new URL(this._jobHistoryFile);
        jobConf.addResource(jobConfFileUrl);
        if (jobHistoryFileUrl.getProtocol().equals("hdfs")) {
            DefaultJobHistoryParser.parseJobTasks((String)jobHistoryFileUrl.getPath(), (JobHistory.JobInfo)jobInfo, (FileSystem)FileSystem.get((Configuration)jobConf));
        } else if (jobHistoryFileUrl.getProtocol().equals("file")) {
            DefaultJobHistoryParser.parseJobTasks((String)jobHistoryFileUrl.getPath(), (JobHistory.JobInfo)jobInfo, (FileSystem)FileSystem.getLocal((Configuration)jobConf));
        } else {
            throw new Exception("Malformed URL. Protocol: " + jobHistoryFileUrl.getProtocol());
        }
    }

    private static void printHelp() {
        System.out.println("Usage:");
        System.out.println("PostExPerformanceDiagnoser -jobconf <fileurl> -joblog <fileurl> [-testconf <filepath>] [-report <filepath>]");
        System.out.println();
        System.out.println("-jobconf <fileurl>     : File path for job configuration file (e.g. job_xxxx_conf.xml). It can be on HDFS or");
        System.out.println("                       : local file system. It should be specified in the URL format.");
        System.out.println("                       : e.g. local file => file://localhost/Users/hadoop-user/job_0001_conf.xml");
        System.out.println("                       : e.g. hdfs file  => hdfs://namenode:port/Users/hadoop-user/hodlogs/.../job_0001_conf.xml");
        System.out.println();
        System.out.println("-joblog <fileurl>      : File path for job history log file. It can be on HDFS or local file system.");
        System.out.println("                       : It should be specified in the URL format.");
        System.out.println();
        System.out.println("-testconf <filepath>   : Optional file path for performance advisor tests configuration file. It should be available");
        System.out.println("                       : on local file system and be specified as as an absolute file path.");
        System.out.println("                       : e.g. => /Users/hadoop-user/postex_diagnosis_tests.xml. If not specified default file will be used");
        System.out.println("                       : from the hadoop-{ver}-vaidya.jar in a classpath.");
        System.out.println("                       : For user to view or make local copy of default tests, file is available at $HADOOP_HOME/contrib/vaidya/conf/postex_diagnosis_tests.xml");
        System.out.println();
        System.out.println("-report <filepath>     : Optional file path for for storing diagnostic report in a XML format. Path should be available");
        System.out.println("                       : on local file system and be specified as as an absolute file path.");
        System.out.println("                       : e.g. => /Users/hadoop-user/postex_diagnosis_report.xml. If not specified report will be printed on console");
        System.out.println();
        System.out.println("-help                  : prints this usage");
        System.out.println();
    }

    public static void main(String[] args) {
        String jobconffile = null;
        String joblogfile = null;
        FileInputStream testsconffileis = null;
        String reportfile = null;
        try {
            for (int i = 0; i < args.length - 1; i += 2) {
                if (args[i].equalsIgnoreCase("-jobconf")) {
                    jobconffile = args[i + 1];
                    continue;
                }
                if (args[i].equalsIgnoreCase("-joblog")) {
                    joblogfile = args[i + 1];
                    continue;
                }
                if (args[i].equalsIgnoreCase("-testconf")) {
                    testsconffileis = new FileInputStream(new File(args[i + 1]));
                    continue;
                }
                if (args[i].equalsIgnoreCase("-report")) {
                    reportfile = args[i + 1];
                    continue;
                }
                if (args[i].equalsIgnoreCase("-help")) {
                    PostExPerformanceDiagnoser.printHelp();
                    return;
                }
                PostExPerformanceDiagnoser.printHelp();
                return;
            }
        }
        catch (Exception e) {
            System.err.println("Invalid arguments.");
            e.printStackTrace();
            System.err.println();
            PostExPerformanceDiagnoser.printHelp();
        }
        if (jobconffile == null || joblogfile == null) {
            System.err.println("Invalid arguments: -jobconf or -joblog arguments are missing");
            PostExPerformanceDiagnoser.printHelp();
            return;
        }
        try {
            PostExPerformanceDiagnoser pa = new PostExPerformanceDiagnoser(jobconffile, joblogfile, testsconffileis, reportfile);
            if (pa.getTestsConfFileIs() == null) {
                InputStream testsconfis = Thread.currentThread().getContextClassLoader().getResourceAsStream("postex_diagnosis_tests.xml");
                pa.setTestsConfFileIs(testsconfis);
            }
            Document rulesDoc = XMLUtils.parse(pa.getTestsConfFileIs());
            NodeList list = rulesDoc.getElementsByTagName("DiagnosticTest");
            int list_size = list.getLength();
            for (int i = 0; i < list_size; ++i) {
                Element dRule = (Element)list.item(i);
                NodeList cNodeList = dRule.getElementsByTagName("ClassName");
                Element cn = (Element)cNodeList.item(0);
                String className = cn.getFirstChild().getNodeValue().trim();
                Class<?> rc = Class.forName(className);
                DiagnosticTest test = (DiagnosticTest)rc.newInstance();
                test.initGlobals(pa.getJobExecutionStatistics(), (Element)list.item(i));
                test.run();
                NodeList nodelist = pa.getReport().getElementsByTagName("PostExPerformanceDiagnosticReport");
                Element root = (Element)nodelist.item(0);
                Element re = test.getReportElement(pa.getReport(), root, i);
            }
            if (pa.getReportFile() == null) {
                pa.printReport();
            } else {
                pa.saveReport(pa.getReportFile());
            }
        }
        catch (Exception e) {
            System.err.print("Exception:" + e);
            e.printStackTrace();
        }
    }
}

