/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.mapred.CapacitySchedulerQueue;
import org.apache.hadoop.mapred.CapacityTaskScheduler;
import org.apache.hadoop.mapred.JobChangeEvent;
import org.apache.hadoop.mapred.JobInProgress;
import org.apache.hadoop.mapred.JobInProgressListener;
import org.apache.hadoop.mapred.JobQueueJobInProgressListener;
import org.apache.hadoop.mapred.JobStatusChangeEvent;

class JobQueuesManager
extends JobInProgressListener {
    private static final Log LOG = LogFactory.getLog(JobQueuesManager.class);
    private CapacityTaskScheduler scheduler;
    private Collection<String> jobQueueNames;
    private Map<String, CapacitySchedulerQueue> jobQueues = new HashMap<String, CapacitySchedulerQueue>();

    JobQueuesManager(CapacityTaskScheduler s) {
        this.scheduler = s;
    }

    void setQueues(Map<String, CapacitySchedulerQueue> queues) {
        this.jobQueues = queues;
        this.jobQueueNames = new ArrayList<String>(queues.keySet());
    }

    public void jobAdded(JobInProgress job) throws IOException {
        LOG.info((Object)("Job " + job.getJobID() + " submitted to queue " + job.getProfile().getQueueName()));
        CapacitySchedulerQueue queue = this.getQueue(job.getProfile().getQueueName());
        if (null == queue) {
            LOG.warn((Object)("Invalid queue " + job.getProfile().getQueueName() + " specified for job" + job.getProfile().getJobID() + ". Ignoring job."));
            return;
        }
        queue.addWaitingJob(job);
        this.scheduler.jobAdded(job);
    }

    private void jobCompleted(JobInProgress job, JobQueueJobInProgressListener.JobSchedulingInfo oldInfo, CapacitySchedulerQueue queue, int runState) {
        LOG.info((Object)("Job " + job.getJobID().toString() + " submitted to queue " + job.getProfile().getQueueName() + " has completed"));
        JobInProgress waitingJob = queue.removeWaitingJob(oldInfo, runState);
        JobInProgress initializingJob = queue.removeInitializingJob(oldInfo, runState);
        JobInProgress runningJob = queue.removeRunningJob(oldInfo, runState);
        if (runningJob != null || initializingJob != null || waitingJob != null) {
            this.scheduler.jobCompleted(job);
        }
    }

    public void jobRemoved(JobInProgress job) {
    }

    private void reorderJobs(JobInProgress job, JobQueueJobInProgressListener.JobSchedulingInfo oldInfo, CapacitySchedulerQueue queue, int runState) {
        if (queue.removeWaitingJob(oldInfo, runState) != null) {
            try {
                queue.addWaitingJob(job);
            }
            catch (IOException ioe) {
                LOG.warn((Object)"Couldn't change priority!");
                return;
            }
        }
        if (queue.removeInitializingJob(oldInfo, runState) != null) {
            queue.addInitializingJob(job);
        }
        if (queue.removeRunningJob(oldInfo, runState) != null) {
            queue.addRunningJob(job);
        }
    }

    private void makeJobRunning(JobInProgress job, JobQueueJobInProgressListener.JobSchedulingInfo oldInfo, CapacitySchedulerQueue queue) {
        queue.addRunningJob(job);
    }

    private void jobStateChanged(JobStatusChangeEvent event, CapacitySchedulerQueue queue) {
        JobInProgress job = event.getJobInProgress();
        JobQueueJobInProgressListener.JobSchedulingInfo oldJobStateInfo = new JobQueueJobInProgressListener.JobSchedulingInfo(event.getOldStatus());
        if (event.getEventType() == JobStatusChangeEvent.EventType.PRIORITY_CHANGED || event.getEventType() == JobStatusChangeEvent.EventType.START_TIME_CHANGED) {
            int runState = job.getStatus().getRunState();
            this.reorderJobs(job, oldJobStateInfo, queue, runState);
        } else if (event.getEventType() == JobStatusChangeEvent.EventType.RUN_STATE_CHANGED) {
            int runState = job.getStatus().getRunState();
            if (runState == 2 || runState == 3 || runState == 5) {
                this.jobCompleted(job, oldJobStateInfo, queue, runState);
            } else if (runState == 1) {
                this.makeJobRunning(job, oldJobStateInfo, queue);
            }
        }
    }

    public void jobUpdated(JobChangeEvent event) {
        JobInProgress job = event.getJobInProgress();
        CapacitySchedulerQueue queue = this.getQueue(job.getProfile().getQueueName());
        if (null == queue) {
            LOG.warn((Object)("Could not find queue " + job.getProfile().getQueueName() + " when updating job " + job.getProfile().getJobID()));
            return;
        }
        if (event instanceof JobStatusChangeEvent) {
            this.jobStateChanged((JobStatusChangeEvent)event, queue);
        }
    }

    CapacitySchedulerQueue getQueue(String queue) {
        return this.jobQueues.get(queue);
    }

    Collection<String> getAllQueues() {
        return Collections.unmodifiableCollection(this.jobQueueNames);
    }
}

